// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/settings-model.ts >>>

import Foundation

open class SettingsModel: Settings, GroupBySubject, SettingsNavigator, AccountSettingsNavigator {
  public let accountsSettings: YSArray<AccountSettings>
  public let accountsManager: AccountsManager
  private var openedAccount: Int32!
  public init(_ accountsSettings: YSArray<AccountSettings>, _ accountsManager: AccountsManager, _ openedAccount: Int32! = nil) {
    self.accountsSettings = accountsSettings
    self.accountsManager = accountsManager
    self.openedAccount = openedAccount
  }

  open func clearCache() {}

  @discardableResult
  open func getThreadingSetting() -> Bool {
    return accountsSettings[self.demandRequiredAccountIndex()].groupBySubject
  }

  open func toggleThreadingSetting() {
    let currentAccountSettings: AccountSettings = accountsSettings[self.demandRequiredAccountIndex()]
    currentAccountSettings.groupBySubject = !currentAccountSettings.groupBySubject
  }

  open func openSettings() {}

  open func openAccountSettings(_ accountIndex: Int32) {
    openedAccount = accountsManager.indexesOfLoggedInAccounts[accountIndex]
  }

  open func closeAccountSettings() {
    openedAccount = nil
  }

  @discardableResult
  private func demandRequiredAccountIndex() -> Int32 {
    return requireNonNull(openedAccount, "Необходимо зайти в настройки аккаунта")
  }
}
