// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/spamable-model.ts >>>

import Foundation

open class SpamableModel: Spamable {
  private var lastSpamActionTime: Int64!
  private var model: MessageListDisplayModel
  private var markableModel: MarkableReadModel
  public init(_ model: MessageListDisplayModel, _ markableModel: MarkableReadModel) {
    self.model = model
    self.markableModel = markableModel
  }

  open func moveToSpam(_ order: Int32) {
    moveToSpamMessages(YSSet<Int32>(YSArray(order)))
  }

  open func moveToSpamMessages(_ orders: YSSet<Int32>) {
    let mids: YSArray<MessageId> = YSArray()
    for order in orders.values() {
      markableModel.markAsRead(order)
      model.getMessageThreadByOrder(order).forEach {
        mid in
        mids.push(mid)
      }
    }
    for mid in mids {
      model.moveMessageToFolder(mid, DefaultFolderName.spam)
    }
    lastSpamActionTime = currentTimeMs()
  }

  @discardableResult
  open func toastShown() -> Bool {
    if lastSpamActionTime == nil {
      return false
    }
    return currentTimeMs() - lastSpamActionTime! < 5000
  }

  open func moveFromSpam(_ order: Int32) {
    moveFromSpamMessages(YSSet<Int32>(YSArray(order)))
  }

  open func moveFromSpamMessages(_ orders: YSSet<Int32>) {
    for mid in model.getMidsByOrders(orders) {
      model.moveMessageToFolder(mid, DefaultFolderName.inbox)
    }
    lastSpamActionTime = currentTimeMs()
  }
}
