// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/write-message-model.ts >>>

import Foundation

open class WriteMessageModel: WriteMessage {
  private var model: MessageListDisplayModel
  private var messageNavigator: MessageNavigatorModel
  private var compose: ComposeMessageModel
  public let accountDataHandler: MailAppModelHandler
  public var wysiwig: WysiwygModel
  public init(_ model: MessageListDisplayModel, _ messageNavigator: MessageNavigatorModel, _ compose: ComposeMessageModel, _ accountDataHandler: MailAppModelHandler, _ wysiwig: WysiwygModel) {
    self.model = model
    self.messageNavigator = messageNavigator
    self.compose = compose
    self.accountDataHandler = accountDataHandler
    self.wysiwig = wysiwig
  }

  open func openCompose() {
    compose.composeDraft = Draft(wysiwig)
  }

  open func sendMessage(_ to: String, _ subject: String) {
    createAndAddSentReceivedMessage(to, subject)
  }

  open func replyMessage() {
    let openedMessage = model.storedMessage(messageNavigator.openedMessage).head
    let msgSentThread = createAndAddSentReceivedMessage(openedMessage.from, "Re: " + openedMessage.subject)
    model.accountDataHandler.getCurrentAccount().threads.forEach {
      thread in
      if thread.has(self.messageNavigator.openedMessage) {
        msgSentThread.forEach {
          msg in
          thread.add(msg)
        }
      }
    }
  }

  @discardableResult
  open func copy() -> WriteMessageModel {
    return WriteMessageModel(model, messageNavigator, compose, accountDataHandler, wysiwig)
  }

  open func sendPrepared() {
    let sentSubject = compose.getDraft().subject == nil ? "" : compose.getDraft().subject!
    let sentTo = compose.getDraft().to.size == 0 ? YSSet<String>() : compose.getDraft().to
    let sentBody: String = compose.getDraft().getWysiwyg().getRichBody()
    let sentMsg = FullMessage(Message(accountDataHandler.getCurrentAccount().aliases[0], sentSubject, int64(YSDate.now()), 1, true), sentTo, sentBody)
    let messages = model.accountDataHandler.getCurrentAccount().messages
    let sentMsgMid = int64(messages.size)
    messages.set(int64(messages.size), sentMsg)
    model.accountDataHandler.getCurrentAccount().folderToMessages.get(DefaultFolderName.sent)!.add(sentMsgMid)
    var isToIsSelf = false
    for to in sentTo.values() {
      if accountDataHandler.getCurrentAccount().aliases.includes(to) {
        isToIsSelf = true
      }
    }
    if isToIsSelf {
      let receivedMsg = FullMessage(Message(accountDataHandler.getCurrentAccount().aliases[0], sentSubject, int64(YSDate.now()), 1, true), sentTo, sentBody)
      let receivedMsgMid = int64(messages.size)
      messages.set(int64(messages.size), receivedMsg)
      model.accountDataHandler.getCurrentAccount().folderToMessages.get(DefaultFolderName.inbox)!.add(receivedMsgMid)
      model.accountDataHandler.getCurrentAccount().threads.push(YSSet(YSArray(sentMsgMid, receivedMsgMid)))
    }
    compose.composeDraft = nil
  }

  @discardableResult
  private func createAndAddSentReceivedMessage(_ to: String, _ subject: String) -> YSArray<MessageId> {
    let sentFakeMid = createOnlySentMessage(to, subject)
    if accountDataHandler.getCurrentAccount().aliases.includes(canonicalEmail(to)) {
      let selfEmail = accountDataHandler.getCurrentAccount().aliases[0]
      let timestamp = currentTimeMs()
      let receivedFakeMid = int64(model.accountDataHandler.getCurrentAccount().messages.size + 1)
      let receivedMessage = FullMessage(Message(to, subject, timestamp + int64(1), 2, false), YSSet<String>(YSArray(selfEmail)))
      model.accountDataHandler.getCurrentAccount().messages.set(receivedFakeMid, receivedMessage)
      model.accountDataHandler.getCurrentAccount().folderToMessages.get(DefaultFolderName.inbox)!.add(receivedFakeMid)
      model.accountDataHandler.getCurrentAccount().threads.push(YSSet(YSArray(sentFakeMid, receivedFakeMid)))
      return YSArray(sentFakeMid, receivedFakeMid)
    }
    return YSArray()
  }

  @discardableResult
  private func canonicalEmail(_ email: String) -> String {
    var cnt = 0
    for i in stride(from: 0, to: email.length, by: 1) {
      if email.slice(i, i + 1) == "-" {
        cnt += 1
      }
    }
    if cnt <= 1 {
      return email
    }
    let pos = email.lastIndexOf("-")
    return "\(email.slice(0, pos)).\(email.slice(pos + 1, email.length))"
  }

  @discardableResult
  private func createOnlySentMessage(_ to: String, _ subject: String) -> MessageId {
    let selfEmail = accountDataHandler.getCurrentAccount().aliases[0]
    let timestamp = currentTimeMs()
    let sentMessage = FullMessage(Message(selfEmail, subject, timestamp, 2, true), YSSet<String>(YSArray(to)))
    let msgSentMid = int64(model.accountDataHandler.getCurrentAccount().messages.size + 1)
    model.accountDataHandler.getCurrentAccount().messages.set(msgSentMid, sentMessage)
    model.accountDataHandler.getCurrentAccount().folderToMessages.get(DefaultFolderName.sent)!.add(msgSentMid)
    return msgSentMid
  }
}
