// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/base-simple-action.ts >>>

import Foundation

open class BaseSimpleAction<F, C>: MBTAction {
  private var type: MBTActionType
  public init(_ type: MBTActionType) {
    self.type = type
  }

  @discardableResult
  open func requiredFeature() -> Feature<F> {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFearures: YSArray<FeatureID>) -> Bool {
    return requiredFeature().includedAll(modelFeatures, applicationFearures)
  }

  @discardableResult
  open func canBePerformed(_ model: App) -> Bool {
    let featuredModel = requiredFeature().forceCast(model)
    return canBePerformedImpl(featuredModel)
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _ history: MBTHistory) -> MBTComponent {
    let currentComponent = history.currentComponent
    let modelFeature: F = requiredFeature().forceCast(model)
    let applicationFeature: F = requiredFeature().forceCast(application)
    let component = currentComponent as! C
    performImpl(modelFeature, component)
    return performImpl(applicationFeature, component)
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func canBePerformedImpl(_: F) -> Bool {
    return true
  }

  @discardableResult
  open func performImpl(_: F, _: C) -> MBTComponent {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func getActionType() -> MBTActionType {
    return type
  }

  @discardableResult
  open func tostring() -> String {
    return getActionType()
  }
}
