// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/mbt-abstractions.ts >>>

import Foundation

public typealias MBTComponentType = String

public protocol MBTComponent {
  func assertMatches(_ model: App, _ application: App) -> Void
  @discardableResult
  func getComponentType() -> MBTComponentType
  @discardableResult
  func tostring() -> String
}

public typealias MBTActionType = String

public protocol MBTAction {
  @discardableResult
  func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool
  @discardableResult
  func canBePerformed(_ model: App) -> Bool
  @discardableResult
  func perform(_ model: App, _ application: App, _ history: MBTHistory) -> MBTComponent
  @discardableResult
  func getActionType() -> MBTActionType
  @discardableResult
  func events() -> YSArray<TestopithecusEvent>
  @discardableResult
  func tostring() -> String
}

public protocol MBTHistory {
  var currentComponent: MBTComponent { get }
  var previousDifferentComponent: MBTComponent! { get }
}

public typealias FeatureID = String

public protocol App {
  var supportedFeatures: YSArray<FeatureID> { get set }
  @discardableResult
  func getFeature(_ feature: FeatureID) -> Any
  @discardableResult
  func dump() -> String
}

open class Feature<T> {
  public let name: FeatureID
  public let description: String
  public init(_ name: FeatureID, _ description: String = "") {
    self.name = name
    self.description = description
  }

  @discardableResult
  open func included(_ supportedFeatures: YSArray<FeatureID>) -> Bool {
    return supportedFeatures.includes(name)
  }

  @discardableResult
  open func includedAll(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return included(modelFeatures) && included(applicationFeatures)
  }

  @discardableResult
  open func forceCast(_ app: App) -> T {
    let t: T! = castIfSupported(app)
    if t == nil {
      fatalError("Feature '\(name)' is unsupported!")
    }
    return t!
  }

  @discardableResult
  open func castIfSupported(_ app: App) -> T! {
    if !app.supportedFeatures.includes(name) {
      return nil
    }
    return cast(app.getFeature(name))
  }

  @discardableResult
  open func cast(_ obj: Any) -> T {
    return obj as! T
  }

  open func performIfSupported(_ app: App, _ action: @escaping (T) -> Void) {
    let featured: T! = castIfSupported(app)
    if featured != nil {
      action(featured)
    }
  }
}

open class FeatureRegistry {
  private var registry: YSMap<FeatureID, Any> = YSMap()
  public init() {}

  @discardableResult
  open func register<T>(_ feature: Feature<T>, _ implementation: T) -> FeatureRegistry {
    registry.set(feature.name, castToAny(implementation))
    return self
  }

  @discardableResult
  open func get(_ feature: FeatureID) -> Any {
    let result = undefinedToNull(registry.get(feature))
    if result == nil {
      fatalError("Unsupported feature \(feature)")
    }
    return result!
  }
}
