// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/state-machine.ts >>>

import Foundation

open class StateMachine {
  private var model: App
  private var application: App
  private var walkStrategy: WalkStrategy
  private var logger: Logger
  public init(_ model: App, _ application: App, _ walkStrategy: WalkStrategy, _ logger: Logger) {
    self.model = model
    self.application = application
    self.walkStrategy = walkStrategy
    self.logger = logger
  }

  @discardableResult
  open func go(_ start: MBTComponent, _ limit: Int32! = nil) -> Bool {
    var currentComponent: MBTComponent! = start
    let history = HistoryBuilder(start)
    var i: Int32 = 0
    while currentComponent != nil {
      currentComponent = step(history)
      if currentComponent != nil {
        history.next(currentComponent!)
      }
      i += 1
      if i == limit {
        break
      }
    }
    return i > 1
  }

  @discardableResult
  open func step(_ history: MBTHistory) -> MBTComponent! {
    let current = history.currentComponent
    let action: MBTAction! = walkStrategy.nextAction(model, application.supportedFeatures, current)
    if action == nil {
      logger.log("No possible actions available")
      return nil
    }
    logAction(action, "==========")
    if !action.supported(model.supportedFeatures, application.supportedFeatures) {
      fatalError("Can\'t perform \(action.tostring()), because application doesn\'t support it")
    }
    if !action.canBePerformed(model) {
      fatalError("Can\'t perform \(action.tostring()), because it can\'t be performed in current model state")
    }
    logAction(action, "Performing action \(action.tostring()) on current component \(current.tostring())")
    let nextComponent = action.perform(model, application, history)
    logAction(action, "Action \(action.tostring()) on component \(current.tostring()) performed, new component is \(nextComponent.tostring())")
    logAction(action, "==========\n")
    return nextComponent
  }

  private func logAction(_ action: MBTAction, _ message: String) {
    if !fakeActions().includes(action.getActionType()) {
      logger.log(message)
    }
  }
}

open class HistoryBuilder: MBTHistory {
  public var previousDifferentComponent: MBTComponent!
  public var currentComponent: MBTComponent
  public init(_ currentComponent: MBTComponent) {
    self.currentComponent = currentComponent
  }

  @discardableResult
  open func next(_ component: MBTComponent) -> HistoryBuilder {
    if currentComponent.tostring() != component.tostring() {
      previousDifferentComponent = currentComponent
      currentComponent = component
    }
    return self
  }
}

public protocol WalkStrategy {
  @discardableResult
  func nextAction(_ model: App, _ applicationFeatures: YSArray<FeatureID>, _ component: MBTComponent) -> MBTAction!
}
