// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/fixed-scenario-strategy.ts >>>

import Foundation

open class FixedScenarioStrategy: WalkStrategy {
  private var position: Int32 = 0
  private var scenario: YSArray<MBTAction>
  public init(_ scenario: YSArray<MBTAction>) {
    self.scenario = scenario
  }

  @discardableResult
  open func nextAction(_: App, _: YSArray<FeatureID>, _: MBTComponent) -> MBTAction! {
    if position == scenario.length {
      return nil
    }
    let action = scenario[self.position]
    position += 1
    return action
  }
}

open class TestPlan {
  private var actions: YSArray<MBTAction> = YSArray()
  private init() {}

  @discardableResult
  open class func yandexLogin(_ account: UserAccount) -> TestPlan {
    return TestPlan().then(YandexLoginAction(account))
  }

  @discardableResult
  open class func empty() -> TestPlan {
    return TestPlan()
  }

  @discardableResult
  open func then(_ action: MBTAction) -> TestPlan {
    return thenChain(YSArray(action))
  }

  @discardableResult
  open func thenTestPlan(_ testPlan: TestPlan) -> TestPlan {
    for action in testPlan.actions {
      actions.push(action)
    }
    return self
  }

  @discardableResult
  open func thenChain(_ actions: YSArray<MBTAction>) -> TestPlan {
    for action in actions {
      self.actions.push(action)
      self.actions.push(DebugDumpAction())
      self.actions.push(AssertAction())
    }
    return self
  }

  @discardableResult
  open func unsupportedActions(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> YSArray<MBTAction> {
    let result: YSArray<MBTAction> = YSArray()
    for action in actions {
      if !action.supported(modelFeatures, applicationFeatures) {
        result.push(action)
      }
    }
    return result
  }

  @discardableResult
  open func getExpectedEvents() -> YSArray<TestopithecusEvent> {
    let result: YSArray<TestopithecusEvent> = YSArray()
    for action in actions {
      for event in action.events() {
        result.push(event)
      }
    }
    return result
  }

  @discardableResult
  open func build(_ accountLocks: YSArray<UserLock>!, _ assertionsEnabled: Bool = true) -> WalkStrategy {
    let actions: YSArray<MBTAction> = YSArray()
    for action in self.actions {
      if assertionsEnabled || AssertAction.type != action.getActionType() {
        actions.push(action)
      }
      if accountLocks != nil {
        accountLocks!.forEach {
          accLock in
          actions.push(PingAccountLockAction(accLock))
        }
      }
    }
    return FixedScenarioStrategy(actions)
  }

  @discardableResult
  open func tostring() -> String {
    var s = "PATH\n"
    for action in actions {
      s += action.tostring() + "\n"
    }
    return s + "END\n"
  }
}

open class MailTestRunner {
  private var userPool: UserPool
  private var mailboxPreparer: MailboxPreparer
  private var oauthService: OauthService
  private var locks: YSArray<UserLock> = YSArray()
  private var modelProvider: AppModelProvider!
  private var testPlan: TestPlan!
  private var platform: MBTPlatform
  private var test: MBTTest
  private var network: SyncNetwork
  private var jsonSerializer: JSONSerializer
  private var sleep: SyncSleep
  private var logger: Logger
  private var assertionsEnabled: Bool
  public init(_ platform: MBTPlatform, _ test: MBTTest, _ network: SyncNetwork, _ jsonSerializer: JSONSerializer, _ sleep: SyncSleep, _ logger: Logger, _ assertionsEnabled: Bool = true) {
    self.platform = platform
    self.test = test
    self.network = network
    self.jsonSerializer = jsonSerializer
    self.sleep = sleep
    self.logger = logger
    self.assertionsEnabled = assertionsEnabled
    let userService = UserService(network, jsonSerializer, logger)
    userPool = UserServicePool(userService, "prod")
    mailboxPreparer = MailboxPreparer(network, jsonSerializer, sleep, logger)
    oauthService = OauthService(network, jsonSerializer)
  }

  @discardableResult
  open func isEnabled(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    if TestsRegistry.testToDebug != nil {
      return true
    }
    let fakeAccounts = test.requiredAccounts().map {
      _ in
      UserAccount("", "")
    }
    let unsupportedActions = test.scenario(fakeAccounts, nil, applicationFeatures).unsupportedActions(modelFeatures, applicationFeatures)
    if unsupportedActions.length > 0 {
      var s = ""
      for action in unsupportedActions {
        s += ";\(action.tostring())"
      }
      logger.log("'\(test.description)': application should support actions: \(s)")
    }
    let ignored = getTestSettings().isIgnored()
    if ignored {
      logger.log("'\(test.description)': помечен как нерабочий. " + "Пожалуйста, почитите это - тесты должна включаться/отключаться через поддержку фичей")
    }
    return unsupportedActions.length == 0 && !ignored
  }

  @discardableResult
  open func lockAndPrepareMailbox() -> YSArray<OAuthUserAccount> {
    logger.log("Try to prepare mailbox for test \(test.description)")
    let min10 = int64(10 * 60 * 1000)
    let min2 = int64(2 * 60 * 1000)
    let requiredAccounts = test.requiredAccounts()
    let accounts: YSArray<OAuthUserAccount> = YSArray()
    let clients: YSArray<MailboxClient> = YSArray()
    let mailboxBuilders: YSArray<ImapMailboxBuilder> = YSArray()
    for accountIndex in stride(from: 0, to: requiredAccounts.length, by: 1) {
      let lock: UserLock! = userPool.tryAcquire(min10, min2)
      if lock == nil {
        releaseLocks()
        return YSArray()
      }
      locks.push(lock!)
    }
    for accountIndex in stride(from: 0, to: locks.length, by: 1) {
      let account = locks[accountIndex].lockedAccount()
      mailboxBuilders.push(ImapMailbox.builder(account))
    }
    test.prepareMailboxes(mailboxBuilders)
    for i in stride(from: 0, to: locks.length, by: 1) {
      let account = locks[i].lockedAccount()
      let mailbox = mailboxBuilders[i].build()
      mailboxPreparer.prepare(mailbox)
      let token = oauthService.getToken(account)
      let client = MailboxClient(MockPlatform.androidDefault, account, token, network, jsonSerializer, logger)
      clients.push(client)
      accounts.push(OAuthUserAccount(account, token))
    }
    modelProvider = MailboxDownloader(clients, logger)
    return accounts
  }

  open func runTest(_ accounts: YSArray<OAuthUserAccount>, _ start: MBTComponent, _ application: App!) {
    logger.log("Test \(test.description) started")
    let modelProvider = requireNonNull(self.modelProvider, "Should lockAndPrepareMailbox before runTest!")
    let model = modelProvider.takeAppModel()
    let model2 = model.copy()
    let model3 = model.copy()
    let supportedFeatures = (application != nil ? application! : model).supportedFeatures
    let testPlan = test.scenario(accounts.map {
      a in
      a.account
    }, modelProvider, supportedFeatures)
    self.testPlan = testPlan
    logger.log(testPlan.tostring())
    let walkStrategyWithState1 = testPlan.build(nil, true)
    let walkStrategyWithState2 = testPlan.build(locks, assertionsEnabled)
    logger.log("Model vs Model testing started")
    let modelVsModel = StateMachine(model, model2, walkStrategyWithState1, logger)
    modelVsModel.go(start)
    logger.log("Model vs Model testing finished")
    logger.log("\n")
    if application == nil {
      return
    }
    logger.log("Model vs Application testing started")
    let modelVsApplication = StateMachine(model3, application, walkStrategyWithState2, logger)
    modelVsApplication.go(start)
    logger.log("Model vs Application testing finished")
    logger.log("\n")
    logger.log("Test \(test.description) finished")
  }

  open func validateLogs(_ logs: String) {
    if !getTestSettings().shouldValidateLogs() {
      logger.log("Тест не хочет, чтобы его логи проверяли")
      return
    }
    let testPlan = requireNonNull(self.testPlan, "Запустите тест runTest сначала!")
    let actualEvents: YSArray<TestopithecusEvent> = YSArray()
    let lines = logs.split("\n")
    for line in lines {
      if line.length > 0 {
        let parser = CrossPlatformLogsParser(jsonSerializer)
        let event = parser.parse(line)
        actualEvents.push(event)
      }
    }
    let expectedEvents = testPlan.getExpectedEvents()
    for i in stride(from: 0, to: max(actualEvents.length, expectedEvents.length), by: 1) {
      if i >= actualEvents.length {
        fatalError("Ожидалось событие '\(expectedEvents[i].name)', но больше нет")
      }
      let actual = actualEvents[i]
      if i >= expectedEvents.length {
        fatalError("Вижу событие '\(actual.name)', но больше не должно быть")
      }
      let expected = expectedEvents[i]
      assertStringEquals(expected.name, actual.name, "Разные события на месте #\(i)")
    }
  }

  open func finish() {
    releaseLocks()
    logger.log("Тест '\(test.description)' закончился")
  }

  @discardableResult
  private func getTestSettings() -> TestSettings {
    let settings = TestSettings(platform)
    test.setupSettings(settings)
    return settings
  }

  private func releaseLocks() {
    if locks.length != 0 {
      locks.forEach {
        lock in
        if lock != nil {
          lock.release()
        }
      }
      locks = YSArray()
      logger.log("Locks for test \(test.description) released")
    }
  }
}

public protocol AppModel: App {
  @discardableResult
  func copy() -> AppModel
}

public protocol AppModelProvider {
  @discardableResult
  func takeAppModel() -> AppModel
}
