// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/user-behaviour-walk-strategy.ts >>>

import Foundation

open class UserBehaviourWalkStrategy: WalkStrategy {
  public let history: YSArray<MBTAction> = YSArray()
  private var currentStep: Int32 = 0
  private var behaviour: UserBehaviour
  private var chooser: ActionChooser
  private var stepsLimit: Int32!
  public init(_ behaviour: UserBehaviour, _ chooser: ActionChooser = RandomActionChooser(), _ stepsLimit: Int32! = nil) {
    self.behaviour = behaviour
    self.chooser = chooser
    self.stepsLimit = stepsLimit
  }

  @discardableResult
  open func nextAction(_ model: App, _ applicationFeatures: YSArray<FeatureID>, _ component: MBTComponent) -> MBTAction! {
    let possibleActions = behaviour.getActions(model, component).filter {
      mbtAction in
      mbtAction.supported(model.supportedFeatures, applicationFeatures)
    }.filter {
      mbtAction in
      mbtAction.canBePerformed(model)
    }
    if possibleActions.length == 0 {
      return nil
    }
    if currentStep == stepsLimit {
      return nil
    }
    let action: MBTAction! = chooser.choose(possibleActions, component)
    if action == nil {
      return nil
    }
    history.push(action)
    currentStep += 1
    return action
  }
}

public protocol ActionChooser {
  @discardableResult
  func choose(_ actions: YSArray<MBTAction>, _ component: MBTComponent) -> MBTAction!
}

open class RandomActionChooser: ActionChooser {
  private var random: RandomProvider
  public init(_ random: RandomProvider = PseudoRandomProvider.INSTANCE) {
    self.random = random
  }

  @discardableResult
  open func choose(_ actions: YSArray<MBTAction>, _: MBTComponent) -> MBTAction! {
    if actions.length == 0 {
      return nil
    }
    let order = random.generate(actions.length)
    return actions[order]
  }
}
