// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/graph-algorithms/distance-algo.ts >>>

import Foundation

open class DistanceAlgo {
  @discardableResult
  open class func getDistances<T>(_ graph: CompressedGraph<T>, _ vertex: Int32, _ component: YSSet<Int32>) -> YSMap<Int32, DistanceAndLastEdgeId> {
    let distances: YSMap<Int32, DistanceAndLastEdgeId> = YSMap<Int32, DistanceAndLastEdgeId>()
    distances.set(vertex, DistanceAndLastEdgeId(0, -1))
    let queue: Queue<Int32> = Queue<Int32>()
    queue.push(vertex)
    while queue.size() > 0 {
      let current = queue.front()
      let current_distance = distances.get(current)!.distance
      queue.pop()
      for edgeId in graph.getEdgesId(current) {
        let edge = graph.edges[edgeId]
        let to = edge.getTo()
        if component.has(to), !distances.has(to) {
          queue.push(to)
          distances.set(to, DistanceAndLastEdgeId(current_distance + 1, edgeId))
        }
      }
    }
    return distances
  }

  @discardableResult
  open class func getPathTo<T>(_ vertex: Int32, _ distances: YSMap<Int32, DistanceAndLastEdgeId>, _ graph: CompressedGraph<T>) -> YSArray<Int32> {
    let path: YSArray<Int32> = YSArray()
    var current = vertex
    while distances.get(current)!.distance > 0 {
      let edgeId = distances.get(current)!.lastEdgeId
      path.push(edgeId)
      current = graph.edges[edgeId].getFrom()
    }
    return path.reverse()
  }
}

open class DistanceAndLastEdgeId {
  public var distance: Int32
  public var lastEdgeId: Int32
  public init(_ distance: Int32, _ lastEdgeId: Int32) {
    self.distance = distance
    self.lastEdgeId = lastEdgeId
  }
}
