// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/graph-algorithms/longest-path-algo.ts >>>

import Foundation

open class LongestPathAlgo {
  @discardableResult
  open class func getLongestPath<T>(_ graph: CompressedGraph<T>, _ logger: Logger) -> YSArray<T> {
    if graph.size() == 0 || graph.countOfEdges() == 0 {
      return YSArray()
    }
    let components = StrongComponentAlgo.getStrongConnectedComponents(graph)
    let condensedGraph = StrongComponentAlgo.getCondensedGraph(graph)
    let longestPath = LongestPathAlgo.getLongestPathInCondensedGraph(condensedGraph, components)
    var current_component: Int32 = 0
    var current_vertex: Int32 = 0
    for i in stride(from: 0, to: components.size(), by: 1) {
      if components.get(i).has(current_vertex) {
        current_component = i
      }
    }
    logger.log("Current component id = \(current_component), size = \(components.get(current_component).size)")
    var path: YSArray<T> = EulerGraphAlgo.getEulerCircleInComponent(graph, components.get(current_component), current_vertex).map {
      edgeId in
      graph.edges[edgeId].getAction()
    }
    var edgeId: Int32
    while longestPath.getEdgesId(current_component).length > 0 {
      edgeId = longestPath.getEdgesId(current_component)[0]
      let condensedEdge = longestPath.edges[edgeId]
      let edge = condensedEdge.getAction()
      let distances = DistanceAlgo.getDistances(graph, current_vertex, components.get(current_component))
      let connected_path = DistanceAlgo.getPathTo(edge.getFrom(), distances, graph).map {
        edgeId in
        graph.edges[edgeId].getAction()
      }
      path = path.concat(connected_path)
      path.push(edge.getAction())
      current_component = condensedEdge.getTo()
      current_vertex = edge.getTo()
      logger.log("Current component id = \(current_component), size = \(components.get(current_component).size)")
      let component_path = EulerGraphAlgo.getEulerCircleInComponent(graph, components.get(current_component), current_vertex).map {
        edgeId in
        graph.edges[edgeId].getAction()
      }
      path = path.concat(component_path)
    }
    return path
  }

  @discardableResult
  private class func getLongestPathInCondensedGraph<T, VertexType>(_ condensed: CompressedGraph<T>, _ components: Stack<YSSet<VertexType>>) -> CompressedGraph<T> {
    let path: CompressedGraph<T> = CompressedGraph()
    var size: YSArray<Int32> = YSArray()
    for _ in stride(from: 0, to: condensed.size(), by: 1) {
      size.push(0)
    }
    let topSort = TopSortAlgo.getTopSort(condensed)
    for i in stride(from: 0, to: topSort.size(), by: 1) {
      let vertex = topSort.get(i)
      size[vertex] += components.get(vertex).size
      var mx: Int32 = -1
      var edge_index: Int32 = -1
      for edgeId in condensed.getEdgesId(vertex) {
        let to = condensed.edges[edgeId].getTo()
        if size[to] > mx {
          mx = size[to]
          edge_index = edgeId
        }
      }
      if edge_index >= 0 {
        size[vertex] += mx
        path.addEdge(vertex, condensed.edges[edge_index].getTo(), condensed.edges[edge_index].getAction())
      }
    }
    return path
  }
}
