// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/graph-algorithms/topsort-algo.ts >>>

import Foundation

open class TopSortAlgo {
  @discardableResult
  open class func getTopSort<T>(_ graph: CompressedGraph<T>) -> Stack<Int32> {
    let dfs: Stack<State> = Stack()
    let used: YSSet<Int32> = YSSet<Int32>()
    let result: Stack<Int32> = Stack()
    for vertex in stride(from: 0, to: graph.size(), by: 1) {
      if !used.has(vertex) {
        dfs.push(State(vertex, 0))
      }
      while dfs.size() > 0 {
        let state = dfs.top()
        if state.iterator == 0 {
          used.add(state.vertex)
        }
        var flag: Bool = true
        for i in stride(from: state.iterator, to: graph.getEdgesId(state.vertex).length, by: 1) {
          let edgeId = graph.getEdgesId(state.vertex)[i]
          let edge = graph.edges[edgeId]
          if !used.has(edge.getTo()) {
            state.iterator = i + 1
            dfs.push(State(edge.getTo(), 0))
            flag = false
            break
          }
        }
        if flag {
          dfs.pop()
          result.push(state.vertex)
        }
      }
    }
    return result
  }
}

private class State {
  public var vertex: Int32
  public var iterator: Int32
  public init(_ vertex: Int32, _ iterator: Int32) {
    self.vertex = vertex
    self.iterator = iterator
  }
}
