// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/hash/full-hash-strategy.ts >>>

import Foundation

open class FullHashStrategy: HashStrategy {
  @discardableResult
  open func getMailboxModelHash(_ model: MailboxModel) -> Int64 {
    let hashBuilder: HashBuilder = HashBuilder().addBoolean(model.rotatable.landscape).addInt64(model.messageNavigator.openedMessage)
    let selectedMessages = model.groupMode.selectedOrders
    if selectedMessages != nil {
      hashBuilder.addInt64(FullHashStrategy.getSelectedMessagesHash(selectedMessages))
    } else {
      hashBuilder.addBoolean(true)
    }
    hashBuilder.addInt(29)
    for message in model.readOnlyExpandableThreads.expanded.values() {
      hashBuilder.addInt64(message)
    }
    hashBuilder.addInt(23)
    if !model.mailAppModelHandler.hasCurrentAccount() {
      return hashBuilder.build()
    }
    let account = model.messageListDisplay.accountDataHandler.getCurrentAccount()
    for thread in account.threads {
      hashBuilder.addInt(19)
      for message in thread.values() {
        hashBuilder.addInt64(message)
      }
    }
    hashBuilder.addInt(17)
    account.messages.__forEach({
      message, id in
      hashBuilder.addInt64(id).addInt64(FullHashStrategy.getMessageHash(message))
    })
    hashBuilder.addInt(13)
    account.folderToMessages.__forEach({
      ids, folder in
      for id in ids.values() {
        hashBuilder.addInt64(id).addString(folder)
      }
    })
    hashBuilder.addString(model.folderNavigator.getCurrentFolder().name)
    return hashBuilder.build()
  }

  @discardableResult
  private class func getFolderHash(_ folder: Folder) -> Int64 {
    return HashBuilder().addString(folder.name).build()
  }

  @discardableResult
  private class func getMessageHash(_ message: FullMessage) -> Int64 {
    let hashBuilder: HashBuilder = HashBuilder().addString(message.head.from).addBoolean(message.head.read).addString(message.head.subject).addBoolean(message.head.important).addInt64(message.mutableHead.timestamp)
    if message.head.threadCounter != nil {
      hashBuilder.addInt64(int64(message.head.threadCounter!))
    } else {
      hashBuilder.addBoolean(true)
    }
    return hashBuilder.build()
  }

  @discardableResult
  private class func getSelectedMessagesHash(_ selectedMessages: YSSet<Int32>) -> Int64 {
    let hashBuilder: HashBuilder = HashBuilder()
    hashBuilder.addInt(11)
    for v in selectedMessages.values() {
      hashBuilder.addInt64(int64(v))
    }
    return hashBuilder.build()
  }
}
