// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/hash/hash-builder.ts >>>

import Foundation

open class HashBuilder {
  private static var mod: Int64 = stringToInt64("1125899839733759")!
  private static var multiplier: Int64 = int64(63)
  private var hash: Int64 = int64(0)
  @discardableResult
  private class func getHashOfString(_ str: String) -> Int64 {
    var hash: Int64 = int64(0)
    let multiplier: Int64 = int64(257)
    for i in stride(from: 0, to: str.length, by: 1) {
      let ch = str.charCodeAt(i)
      hash = (hash * multiplier + int64(ch)) % mod
    }
    return hash
  }

  @discardableResult
  open func addInt64(_ number: Int64) -> HashBuilder {
    hash = (hash * HashBuilder.multiplier + number) % HashBuilder.mod
    return self
  }

  @discardableResult
  open func addInt(_ number: Int32) -> HashBuilder {
    return addInt64(int64(number))
  }

  @discardableResult
  open func addBoolean(_ condition: Bool) -> HashBuilder {
    return addInt64(int64(condition ? 1 : 0))
  }

  @discardableResult
  open func addString(_ str: String) -> HashBuilder {
    return addInt64(HashBuilder.getHashOfString(str))
  }

  @discardableResult
  open func build() -> Int64 {
    return hash
  }
}

public protocol HashStrategy {
  @discardableResult
  func getMailboxModelHash(_ model: MailboxModel) -> Int64
}
