// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mbt/walk/limits/personal-action-limits.ts >>>

import Foundation

open class PersonalActionLimits: ActionLimitsStrategy {
  private var personalLimits: YSMap<MBTActionType, Int32> = YSMap<MBTActionType, Int32>()
  private var totalLimit: Int32
  public init(_ totalLimit: Int32) {
    self.totalLimit = totalLimit
  }

  @discardableResult
  open func setLimit(_ action: MBTActionType, _ limit: Int32) -> PersonalActionLimits {
    personalLimits.set(action, limit)
    return self
  }

  @discardableResult
  open func check(_ actions: Stack<MBTAction>) -> Bool {
    if totalLimit <= actions.size() {
      return false
    }
    for actionType in personalLimits.keys() {
      var count: Int32 = 0
      for i in stride(from: 0, to: actions.size(), by: 1) {
        if actions.get(i).getActionType() == actionType {
          count += 1
        }
      }
      if count >= personalLimits.get(actionType)! {
        return false
      }
    }
    return true
  }
}
