// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM tests/base-user-behaviour-test.ts >>>

import Foundation

open class BaseUserBehaviourTest: AbstractMBTTest {
  public let pathLength: Int32
  public let logger: Logger
  public let seed: Int32
  public init(_ description: String, _ pathLength: Int32, _ logger: Logger, _ seed: Int32) {
    self.pathLength = pathLength
    self.logger = logger
    self.seed = seed
    super.init(description)
  }

  @discardableResult
  open override func requiredAccounts() -> YSArray<AccountType> {
    fatalError("Must be overridden in subclasses")
  }

  open override func prepareMailboxes(_: YSArray<ImapMailboxBuilder>) {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func getUserBehaviour(_: YSArray<UserAccount>) -> UserBehaviour {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open override func scenario(_ accounts: YSArray<UserAccount>, _ modelProvider: AppModelProvider!, _ supportedFeatures: YSArray<FeatureID>) -> TestPlan {
    if modelProvider == nil {
      return TestPlan.empty()
    }
    let model = modelProvider!.takeAppModel()
    let random = PseudoRandomProvider(seed)
    let behaviour = getUserBehaviour(accounts)
    let walkStrategy = UserBehaviourWalkStrategy(behaviour, RandomActionChooser(random), pathLength)
    var applicationModel = model.copy()
    applicationModel.supportedFeatures = supportedFeatures
    let stateMachine = StateMachine(model, applicationModel, walkStrategy, logger)
    stateMachine.go(LoginComponent())
    return TestPlan.empty().thenChain(walkStrategy.history)
  }
}

open class FullCoverageBaseTest: AbstractMBTTest {
  private var logger: Logger
  public init(_ description: String, _ logger: Logger) {
    self.logger = logger
    super.init(description)
  }

  @discardableResult
  open override func requiredAccounts() -> YSArray<AccountType> {
    fatalError("Must be overridden in subclasses")
  }

  open override func prepareMailboxes(_: YSArray<ImapMailboxBuilder>) {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func getUserBehaviour(_: YSArray<UserAccount>) -> UserBehaviour {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func getActionLimits() -> ActionLimitsStrategy {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open override func scenario(_ accounts: YSArray<UserAccount>, _ modelProvider: AppModelProvider!, _ supportedFeatures: YSArray<FeatureID>) -> TestPlan {
    if modelProvider == nil {
      return TestPlan.empty()
    }
    let runner = MultiRunner(LoginComponent(), getUserBehaviour(accounts), getActionLimits(), modelProvider, supportedFeatures, logger)
    let path = runner.preparePath()
    let pathLength = path.length
    logger.log("Optimal path length: \(pathLength)")
    return TestPlan.empty().thenChain(path)
  }
}
