// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM tests/compose-message-tests.ts >>>

import Foundation

open class SendMessageWithBody: RegularYandexTestBase {
  public init() {
    super.init("should receive message with body")
  }

  open override func setupSettings(_ settings: TestSettings) {
    settings.ignoreOn(MBTPlatform.Android).ignoreOn(MBTPlatform.IOS)
  }

  open override func prepareMailbox(_ mailbox: ImapMailboxBuilder) {
    mailbox.nextMessage("subj")
  }

  @discardableResult
  open override func regularScenario(_ account: UserAccount) -> TestPlan {
    return TestPlan.yandexLogin(account).then(OpenComposeAction()).then(AddToAction(account.login)).thenChain(YSArray(SendPreparedAction(), RefreshMessageListAction())).then(OpenMessage(0))
  }
}

open class SendMessageWithToAddedFromSuggestTest: RegularYandexTestBase {
  public init() {
    super.init("should receive message with to added from suggest")
  }

  open override func setupSettings(_ settings: TestSettings) {
    settings.ignoreOn(MBTPlatform.Android).ignoreOn(MBTPlatform.IOS)
  }

  open override func prepareMailbox(_ builder: ImapMailboxBuilder) {
    builder.nextMessage("subj")
  }

  @discardableResult
  open override func regularScenario(_ account: UserAccount) -> TestPlan {
    return TestPlan.yandexLogin(account).then(OpenComposeAction()).then(AddToFromSuggestAction(account.login.substr(0, 6))).thenChain(YSArray(SendPreparedAction(), RefreshMessageListAction())).then(OpenMessage(0))
  }
}
