// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM tests/group-mode-tests.ts >>>

import Foundation

open class GroupMarkAsReadDifferentMessagesTest: RegularYandexTestBase {
  public init() {
    super.init("should mark as unread selected messages if one is read and one is unread")
  }

  open override func prepareMailbox(_ mailbox: ImapMailboxBuilder) {
    mailbox.nextMessage("subj1").nextMessage("subj2")
  }

  @discardableResult
  open override func regularScenario(_ account: UserAccount) -> TestPlan {
    return TestPlan.yandexLogin(account).then(MarkAsRead(0)).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(MarkAsReadSelectedMessages())
  }
}

open class GroupMarkAsReadMessagesTest: RegularYandexTestBase {
  public init() {
    super.init("should mark as unread selected messages if one is read and one is unread")
  }

  open override func prepareMailbox(_ mailbox: ImapMailboxBuilder) {
    mailbox.nextMessage("subj1").nextMessage("subj2")
  }

  @discardableResult
  open override func regularScenario(_ account: UserAccount) -> TestPlan {
    return TestPlan.yandexLogin(account).then(MarkAsRead(0)).then(MarkAsRead(1)).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(MarkAsUnreadSelectedMessages())
  }
}

open class CanOpenMessageAfterGroupActionTest: RegularYandexTestBase {
  public init() {
    super.init("should be able to open message after group action")
  }

  open override func prepareMailbox(_ mailbox: ImapMailboxBuilder) {
    mailbox.nextMessage("subj1").nextMessage("subj2")
  }

  @discardableResult
  open override func regularScenario(_ account: UserAccount) -> TestPlan {
    return TestPlan.yandexLogin(account).then(MarkAsRead(0)).then(MarkAsRead(1)).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(MarkAsUnreadSelectedMessages()).then(OpenMessage(0))
  }
}

open class GroupDeleteMessagesTest: RegularYandexTestBase {
  public init() {
    super.init("should delete selected messages")
  }

  open override func prepareMailbox(_ mailbox: ImapMailboxBuilder) {
    mailbox.nextMessage("subj1").nextMessage("subj2").nextMessage("subj3").nextMessage("subj4")
  }

  @discardableResult
  open override func regularScenario(_ account: UserAccount) -> TestPlan {
    return TestPlan.yandexLogin(account).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(DeleteSelectedMessages()).then(InitialSelectMessage(0)).then(SelectMessage(1)).then(DeleteSelectedMessages())
  }
}
