// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM tests/login-tests.ts >>>

import Foundation

open class YandexLoginTest: AbstractMBTTest {
  public init() {
    super.init("should login 3 yandex accounts")
  }

  @discardableResult
  open override func requiredAccounts() -> YSArray<AccountType> {
    return YSArray(AccountType.Yandex, AccountType.Yandex, AccountType.Yandex)
  }

  open override func prepareMailboxes(_ mailboxes: YSArray<ImapMailboxBuilder>) {
    mailboxes[0].nextMessage("firstAccountMsg")
    mailboxes[1].nextMessage("secondAccountMsg")
    mailboxes[2].nextMessage("thirdAccountMsg")
  }

  @discardableResult
  open override func scenario(_ accounts: YSArray<UserAccount>, _: AppModelProvider!, _: YSArray<FeatureID>) -> TestPlan {
    return TestPlan.empty().then(YandexLoginAction(accounts[0])).then(GoToAccountSwitcherAction()).then(AddNewAccountAction()).then(YandexLoginAction(accounts[1])).then(GoToAccountSwitcherAction()).then(AddNewAccountAction()).then(YandexLoginAction(accounts[2]))
  }
}

open class SwitchAccountTest: AbstractMBTTest {
  public init() {
    super.init("should switch between 2 yandex accounts")
  }

  @discardableResult
  open override func requiredAccounts() -> YSArray<AccountType> {
    return YSArray(AccountType.Yandex, AccountType.Yandex)
  }

  open override func prepareMailboxes(_ mailboxes: YSArray<ImapMailboxBuilder>) {
    mailboxes[0].nextMessage("firstAccountMsg")
    mailboxes[1].nextMessage("secondAccountMsg")
  }

  @discardableResult
  open override func scenario(_ accounts: YSArray<UserAccount>, _: AppModelProvider!, _: YSArray<FeatureID>) -> TestPlan {
    return TestPlan.empty().then(YandexLoginAction(accounts[0])).then(GoToAccountSwitcherAction()).then(AddNewAccountAction()).then(YandexLoginAction(accounts[1])).then(GoToAccountSwitcherAction()).then(SwitchAccountAction(accounts[0].login)).then(GoToAccountSwitcherAction()).then(SwitchAccountAction(accounts[0].login))
  }
}
