// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM tests/generators/log-test-generator.ts >>>

import Foundation

open class LogTestGenerator: MBTTestGenerator {
  private var rawLogs: YSArray<String> = YSArray()
  private var jsonLogs: YSArray<String> = YSArray()
  private var scenarioParser: ScenarioParser
  private var jsonSerializer: JSONSerializer
  public init(_ jsonSerializer: JSONSerializer) {
    self.jsonSerializer = jsonSerializer
    scenarioParser = ScenarioParser(ActionParser(), self.jsonSerializer)
  }

  @discardableResult
  open func generateTests() -> YSArray<MBTTest> {
    let tests: YSArray<MBTTest> = YSArray()
    for log in rawLogs {
      tests.push(LogGeneratedTest(scenarioParser.parseFromText(log)))
    }
    for log in jsonLogs {
      tests.push(LogGeneratedTest(scenarioParser.parseFromJsonText(log)))
    }
    return tests
  }
}
