// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM users/accounts-manager.ts >>>

import Foundation

open class AccountsManager {
  public let accounts: YSArray<UserAccount>
  public var indexesOfLoggedInAccounts: YSArray<Int32>
  public var currentAccount: Int32!
  public init(_ accounts: YSArray<UserAccount>, _ indexesOfLoggedInAccounts: YSArray<Int32> = YSArray(), _ currentAccount: Int32! = nil) {
    self.accounts = accounts
    self.indexesOfLoggedInAccounts = indexesOfLoggedInAccounts
    self.currentAccount = currentAccount
  }

  open func logInToAccount(_ account: UserAccount) {
    if isAccountLoggedIn(account.login) {
      switchToAccount(account.login)
    }
    for i in stride(from: 0, to: accounts.length, by: 1) {
      if accounts[i].login == account.login, accounts[i].password == account.password {
        indexesOfLoggedInAccounts.push(i)
        currentAccount = i
        return
      }
    }
    fatalError("Account (login=\(account.login);password=\(account.password)) hasn't been downloaded yet")
  }

  open func switchToAccount(_ login: String) {
    if !isAccountLoggedIn(login) {
      fatalError("Account for (login=\(login)) hasn't been logged in yet")
    }
    for i in stride(from: 0, to: accounts.length, by: 1) {
      if accounts[i].login == login {
        currentAccount = i
        return
      }
    }
    fatalError("Account for (login=\(login)) hasn't been logged in yet")
  }

  @discardableResult
  open func isLoggedIn() -> Bool {
    return currentAccount != nil
  }

  @discardableResult
  open func isAccountLoggedIn(_ login: String) -> Bool {
    return indexesOfLoggedInAccounts.filter {
      i in
      self.accounts[i].login == login
    }.length > 0
  }

  @discardableResult
  open func getLoggedInAccounts() -> YSArray<UserAccount> {
    let accountsWhichAreLoggedIn: YSArray<UserAccount> = YSArray()
    indexesOfLoggedInAccounts.forEach {
      i in
      accountsWhichAreLoggedIn.push(self.accounts[i])
    }
    return accountsWhichAreLoggedIn
  }

  @discardableResult
  open func copy() -> AccountsManager {
    return AccountsManager(accounts, copyArray(indexesOfLoggedInAccounts), currentAccount)
  }
}
