// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM users/user-parameters-pool.ts >>>

import Foundation

open class UserParametersUserPool: UserPool {
  public static var EXPIRE_AT_PARAM: String = "mobile_lock_until"
  private var client: MailboxClient
  private var account: UserAccount
  private var logger: Logger
  public init(_ client: MailboxClient, _ account: UserAccount, _ logger: Logger) {
    self.client = client
    self.account = account
    self.logger = logger
  }

  @discardableResult
  open func tryAcquire(_ tryAcquireTimeoutMs: Int64, _ lockTtlMs: Int64) -> UserLock! {
    logger.log("Will try to acquire lock for \(tryAcquireTimeoutMs)ms with TTL \(lockTtlMs)ms")
    let start = currentTimeMs()
    while currentTimeMs() < start + tryAcquireTimeoutMs {
      let now = currentTimeMs()
      let expirationTime: Int64! = getExpirationTime()
      if expirationTime == nil || expirationTime < now {
        let expireAt = now + lockTtlMs
        logger.log("Locking until \(expireAt)")
        client.setParameter(UserParametersUserPool.EXPIRE_AT_PARAM, "\(expireAt)")
        if isLocked(expireAt) {
          logger.log("Lock acquired")
          return UserParametersLock(client, account, logger)
        }
      } else {
        logger.log("\((expirationTime! - now) / int64(1000)) seconds before unlock")
      }
    }
    logger.log("Can\'t acquire lock")
    return nil
  }

  open func reset() {
    UserParametersLock(client, account, logger).release()
  }

  @discardableResult
  private func getExpirationTime() -> Int64! {
    let userParameters = client.getSettings().payload!.userParameters.keyValues
    let expireAt: String! = undefinedToNull(userParameters.get(UserParametersUserPool.EXPIRE_AT_PARAM))
    if expireAt == nil || expireAt == "" {
      return nil
    }
    return stringToInt64(expireAt)!
  }

  @discardableResult
  private func isLocked(_ expireAt: Int64) -> Bool {
    for _ in stride(from: 0, to: 3, by: 1) {
      if getExpirationTime() != expireAt {
        return false
      }
    }
    return true
  }
}

open class UserParametersLock: UserLock {
  private var client: MailboxClient
  private var account: UserAccount
  private var logger: Logger
  public init(_ client: MailboxClient, _ account: UserAccount, _ logger: Logger) {
    self.client = client
    self.account = account
    self.logger = logger
  }

  @discardableResult
  open func lockedAccount() -> UserAccount {
    return account
  }

  open func ping(_ newTtlMs: Int64) {
    logger.log("Pinging lock")
    let expireAt = currentTimeMs() + newTtlMs
    client.setParameter(UserParametersUserPool.EXPIRE_AT_PARAM, "\(expireAt)")
  }

  open func release() {
    client.setParameter(UserParametersUserPool.EXPIRE_AT_PARAM, "")
    logger.log("Lock released")
  }
}
