// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM users/user-service.ts >>>

import Foundation

open class UserServiceAccount {
  public var login: String
  public var password: String
  public var uid: String
  public init(_ login: String, _ password: String, _ uid: String) {
    self.login = login
    self.password = password
    self.uid = uid
  }
}

open class UserService {
  private var network: SyncNetwork
  private var jsonSerializer: JSONSerializer
  private var logger: Logger
  public init(_ network: SyncNetwork, _ jsonSerializer: JSONSerializer, _ logger: Logger) {
    self.network = network
    self.jsonSerializer = jsonSerializer
    self.logger = logger
  }

  @discardableResult
  open func getAccount(_ tag: String!, _ lockDuration: Int32, _ ignoreLocks: Bool, _ uidd: String!) -> UserServiceAccount! {
    let response = syncRequest(GetAccountRequest(tag, lockDuration, ignoreLocks, uidd))
    let account = response.get("account") as! MapJSONItem
    if account == nil {
      return nil
    }
    let login: String! = account.getString("login")
    let password: String! = account.getString("password")
    let uid: String! = account.getString("uid")
    if login == nil || password == nil || uid == nil {
      return nil
    }
    logger.log("Got account login=\(login!) password=\(password!) uid=\(uid!)")
    return UserServiceAccount(login!, password!, uid!)
  }

  open func unlockAccount(_ uid: String) {
    syncRequest(UnlockAccountRequest(uid))
  }

  @discardableResult
  private func syncRequest(_ networkRequest: NetworkRequest) -> MapJSONItem {
    let response = network.syncExecute(PublicBackendConfig.userServiceUrl, networkRequest, nil)
    let json = jsonSerializer.deserialize(response) {
      item in
      Result(item, nil)
    }.getValue()
    return json as! MapJSONItem
  }
}

private class GetAccountRequest: NetworkRequest {
  private var tag: String!
  private var lockDuration: Int32
  private var ignoreLocks: Bool
  private var uid: String!
  public init(_ tag: String!, _ lockDuration: Int32, _ ignoreLocks: Bool, _ uid: String!) {
    self.tag = tag
    self.lockDuration = lockDuration
    self.ignoreLocks = ignoreLocks
    self.uid = uid
  }

  @discardableResult
  public func encoding() -> RequestEncoding {
    return UrlRequestEncoding()
  }

  @discardableResult
  public func method() -> NetworkMethod {
    return NetworkMethod.get
  }

  @discardableResult
  public func params() -> MapJSONItem {
    let params = MapJSONItem().putString("tus_consumer", "testopithecus").putInt32("lock_duration", lockDuration).putBoolean("ignore_locks", ignoreLocks)
    if tag != nil {
      params.putString("tags", tag!)
    }
    if uid != nil {
      params.putString("uid", uid!)
    }
    return params
  }

  @discardableResult
  public func urlExtra() -> MapJSONItem {
    return MapJSONItem()
  }

  @discardableResult
  public func version() -> NetworkAPIVersions {
    return NetworkAPIVersions.unspecified
  }

  @discardableResult
  public func path() -> String {
    return "1/get_account/"
  }
}

private class UnlockAccountRequest: NetworkRequest {
  private var uid: String
  public init(_ uid: String) {
    self.uid = uid
  }

  @discardableResult
  public func encoding() -> RequestEncoding {
    return UrlRequestEncoding()
  }

  @discardableResult
  public func method() -> NetworkMethod {
    return NetworkMethod.post
  }

  @discardableResult
  public func params() -> MapJSONItem {
    return MapJSONItem().putString("uid", uid)
  }

  @discardableResult
  public func urlExtra() -> MapJSONItem {
    return MapJSONItem()
  }

  @discardableResult
  public func version() -> NetworkAPIVersions {
    return NetworkAPIVersions.unspecified
  }

  @discardableResult
  public func path() -> String {
    return "1/unlock_account/"
  }
}
