// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM users/user-service-pool.ts >>>

import Foundation

open class UserServicePool: UserPool {
  private var userService: UserService
  private var tag: String!
  public init(_ userService: UserService, _ tag: String!) {
    self.userService = userService
    self.tag = tag
  }

  @discardableResult
  open func tryAcquire(_ tryAcquireTimeoutMs: Int64, _ lockTtlMs: Int64) -> UserLock! {
    let start = currentTimeMs()
    while currentTimeMs() < start + tryAcquireTimeoutMs {
      let user: UserServiceAccount! = userService.getAccount(tag, int64ToInt32(lockTtlMs / int64(1000)), false, nil)
      if user != nil {
        return UserServiceLock(userService, user!)
      }
    }
    return nil
  }

  open func reset() {
    let account: UserServiceAccount! = userService.getAccount(tag, 0, true, nil)
    if account == nil {
      return
    }
    userService.unlockAccount(account!.uid)
  }
}

open class UserServiceLock: UserLock {
  private var userService: UserService
  private var account: UserServiceAccount
  public init(_ userService: UserService, _ account: UserServiceAccount) {
    self.userService = userService
    self.account = account
  }

  @discardableResult
  open func lockedAccount() -> UserAccount {
    return UserAccount(account.login, account.password)
  }

  open func ping(_ newLockTtlMs: Int64) {
    userService.getAccount(nil, int64ToInt32(newLockTtlMs / int64(1000)), true, account.uid)
  }

  open func release() {
    userService.unlockAccount(account.uid)
  }
}
