// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM utils/platform.ts >>>

import Foundation

public enum PlatformType: String, Codable {
  case android
  case electron
  case ios
  case touch
  public func toString() -> String {
    return rawValue
  }
}

@discardableResult
public func platformToClient(_ platform: Platform) -> String {
  switch platform.type {
  case PlatformType.android:
    return platform.isTablet ? "apad" : "aphone"
  case PlatformType.ios:
    return platform.isTablet ? "ipad" : "iphone"
  case PlatformType.electron:
    return "unknown"
  case PlatformType.touch:
    return "unknown"
  }
}

public protocol Platform {
  var type: PlatformType { get }
  var isTablet: Bool { get }
}

open class MockPlatform: Platform {
  public static var androidDefault: Platform = MockPlatform(PlatformType.android, false)
  public let type: PlatformType
  public let isTablet: Bool
  public init(_ type: PlatformType, _ isTablet: Bool) {
    self.type = type
    self.isTablet = isTablet
  }
}
