// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM utils/random.ts >>>

import Foundation

public protocol RandomProvider {
  @discardableResult
  func generate(_ n: Int32) -> Int32
}

@discardableResult
public func randomInt(_ random: RandomProvider, _ min: Int32, _ max: Int32) -> Int32 {
  return random.generate(max - min) + min
}

@discardableResult
public func randomInterval(_ random: RandomProvider, _ min: Int32, _ max: Int32) -> YSArray<Int32> {
  let first = randomInt(random, min, max)
  let second = randomInt(random, min, max)
  if first > second {
    return YSArray(second, first)
  } else {
    return YSArray(first, second)
  }
}
