#!/bin/bash

ForwardAgent=`ssh-add -l 2>/dev/null`
if [ "$ForwardAgent" == "" ];then
  echo "###################################################################################"
  echo "                  ForwardAgent is disabled for this host."
  echo " See, how to enable: https://developer.github.com/guides/using-ssh-agent-forwarding/"
  echo "###################################################################################"
  exit 1
fi

fingerprints=$(ssh-add -l | awk '{print $2}')

for fingerprint in $fingerprints; do
  echo "Searching key: "$fingerprint

  for dir in $(ls -1 /home/); do
    current=$(ssh-keygen -lf /home/$dir/.ssh/authorized_keys 2>/dev/null | awk '{print $2}')
    if [ "$fingerprint" == "$current" ];then
      (id $dir | grep -q yandex ) &&
      user=$dir
      echo "User detected: "$user
    fi
  done
done

if [ -z $user ];then
  echo "Cant't find "$fingerprint" in /home/*"
  exit 1
fi
