import json
import os
from subprocess import Popen, PIPE


def get_queue(name=None):
    process = Popen(['postqueue', '-j'], stdout=PIPE)
    queue_lines = process.communicate()[0].splitlines()
    items = (json.loads(q) for q in queue_lines)
    return [item for item in items if name is None or item['queue_name'] == name]


def get_mail(queue_id):
    if not queue_id:
        raise RuntimeError('Empty queue id')
    process = Popen(['sudo', 'postcat', '-bh', '-q', queue_id], stdout=PIPE)
    return process.communicate()[0]


def hold(queue_id):
    if not queue_id:
        raise RuntimeError('Empty queue id')
    rc = os.system('sudo postsuper -h ' + queue_id)
    return rc


def unhold(queue_id):
    if not queue_id:
        raise RuntimeError('Empty queue id')
    rc = os.system('sudo postsuper -H ' + queue_id)
    return rc


def drop(queue_id, queue_name):
    if not queue_id:
        raise RuntimeError('Empty queue id')
    if not queue_name:
        raise RuntimeError('Empty queue name')
    rc = os.system('sudo postsuper -d ' + queue_id + ' ' + queue_name)
    return rc


def remove_messages(queue_ids):
    process = Popen(['sudo', 'postsuper', '-d', '-'], stdin=PIPE)
    process.communicate(input='\n'.join(queue_ids))


def is_from_deferred(item):
    return item['queue_name'] == 'deferred'


def has_single_rcpt(item):
    return len(item['recipients']) == 1


def get_domain(addr):
    return addr.split('@')[-1]


def is_from_mailer_daemon(item):
    return item['sender'] == 'MAILER-DAEMON'
