#!/usr/bin/python
# -*- coding: UTF-8 -*-

from urllib import urlencode
from urllib2 import urlopen, Request, HTTPError
from collections import defaultdict
import json
import requests
import re
import sys
import ssl

SECRETS_FILE = '/etc/qnductor-sec.json'

CONDUCTOR_API = 'https://c.yandex-team.ru/api/v1/'
QLOUD_API = 'https://qloud-ext.yandex-team.ru/api/v1/status/'
QLOUD_API_TIMEOUT = 10

conductor_project_id = 35
conductor_main_parent_group_id = 26899

QLOUD_GOOD_STATES = ['ACTIVE', 'PREPARED']

# Must specify these due to qloud api limitations
QLOUD_ROUTERS_WHITE_LIST = (
    'mail-ext-common',
    'mail-furita',
    'mail-furita-corp',
    'mail-int-common',
    'mail-int-dynamic-common',
    'mail-int-mailnets',
    'mail-int-qa-common',
    'mail-int-test-common',
    'mail-settings',
    'pdd-api',
    'postmaster',
    'xiva-daria',
    'xiva-tst',
    'xivacorp-daria',
    'xivahub',
    'xivahub-tst',
    'xivahubcorp',
    'xivahubyamb',
    'sender',
)

secrets = json.load(open(SECRETS_FILE))
CONDUCTOR_TOKEN = secrets['CONDUCTOR_TOKEN']
QLOUD_TOKEN = secrets['QLOUD_TOKEN']

def getQloudPath(group):
    request = Request(CONDUCTOR_API + 'groups/' + group,
                      headers={"Authorization": "OAuth " + CONDUCTOR_TOKEN})
    contents = json.loads(urlopen(request).read())
    return contents['value']['description']


def getQloudInstances(qloud_path):
    request = Request(QLOUD_API + qloud_path,
                      headers={"Authorization": "OAuth " + QLOUD_TOKEN})
    contents = json.loads(urlopen(request).read())
    instances = []
    for instance in contents:
        if instance['instanceCurrentState'] in QLOUD_GOOD_STATES:
            instances.append(instance['instanceFqdn'])
    return instances


def getGroupsDescription():
    groups = json.loads(urlopen(
        'https://c.yandex-team.ru/api/groups?format=json').read())
    groups_description = {}
    for group in groups:
        if "qloud_mail" in group["parents"]:
            groups_description[group['name']] = group['description']
    return groups_description


def getGroupHosts(group):
    url = 'https://c.yandex-team.ru/api/groups2hosts/' + \
        group + '?format=json'
    hosts = []
    for item in json.loads(urlopen(url).read()):
        hosts.append(item['fqdn'])
    return hosts


def getQloudComponentsInstances(qloud_project):
    request = Request(QLOUD_API + qloud_project,
                      headers={"Authorization": "OAuth " + QLOUD_TOKEN})
    try_cnt = 0
    while try_cnt <= 5:
        try_cnt +=1
        try:
            print "- try %d" % (try_cnt)
            contents = json.loads(urlopen(request, timeout=QLOUD_API_TIMEOUT).read())
            print "\tsuccess"
            break
        except ssl.SSLError as err:
            print "\tSSL connection failed: %s" % (str(err))

    components = defaultdict(list)
    for item in contents:
        component = item['componentId']
        if item['instanceFqdn'] not in components[component]:
            components[component].append(item['instanceFqdn'])
    return components


def getConductorGroupsHosts():
    groups_hosts = {}
    url = 'http://c.yandex-team.ru/api/groups_export?format=json'
    lines = urlopen(url).read().splitlines()
    for line in lines:
        group = line.split(':')[0]
        hosts = line.split(':')[1].split(',')
        if hosts[0] == "":
            hosts = []
        groups_hosts[group] = hosts
    return groups_hosts

def isMetaGroup(group):
    description = json.loads(urlopen(
    'https://c.yandex-team.ru/api/groups/' + group + '?format=json').read())[0]['description']
    if description == "meta":
        return True
    return False

print "== FETCHING CONDUCTOR GROUPS =="
groups = json.loads(urlopen(
    'https://c.yandex-team.ru/api/groups/qloud_mail?format=json').read())[0]['children']

#groups_description = getGroupsDescription()
#print groups_description
#exit()

print "== FETCHING QLOUD COMPONENTS =="
components_instances = getQloudComponentsInstances('mail')


print "== FETCHING QLOUD BALANCERS =="
for balancer in QLOUD_ROUTERS_WHITE_LIST:
    print " [*] fetching %s " % (balancer)
    components_instances.update(getQloudComponentsInstances('qloud.balancer.' + balancer))
components = components_instances.keys()


print "== PROCESSING CONDUCTOR EXPORT =="
conductor_groups_hosts = getConductorGroupsHosts()

for router in QLOUD_ROUTERS_WHITE_LIST:
    components.append('qloud.balancer.{}.qloud-router'.format(router))
    components.append('qloud.balancer.{}.balancer-l7'.format(router))


# Обновляем список групп в кондукторе на основе компонентов Qloud:
for component in components:
    cond_group = re.sub('\.', '_', component)
    if cond_group in groups:
        print " [*] %s already exist in conductor" % (cond_group)
        continue
    host_data = {'group[name]': cond_group, 'group[project_id]': conductor_project_id, 'group[description]': component,
                 'group[parent_ids][]': conductor_main_parent_group_id, 'group[export_to_racktables]': 'false'}
    host_data = urlencode(host_data)
    ans = requests.post(CONDUCTOR_API + 'groups', headers={
                        "Authorization": "OAuth " + CONDUCTOR_TOKEN}, data=host_data).status_code
    print "%s: %s" % (ans, component)

# Заполняем кондукторные группы хостами из Qloud:
for group in groups:
    print "\n\n ==== %s ==== " % (group)
    qloud_path = re.sub('_', '.', group)

    qloud_hosts = components_instances[qloud_path]

    conductor_hosts = conductor_groups_hosts[group]

    if set(conductor_hosts) == set(qloud_hosts):
        print " [*] Nothing to change in group"
        continue

    if len(set(conductor_hosts) - set(qloud_hosts)) > 0:
        print "\n == PURGING %s ==" % (group)

        # Проверяем, что чистим не мета-группу:
        if len(qloud_hosts) == 0:
            if isMetaGroup(group):
                print " [*] Skipping metagroup"
                continue

        for host in set(conductor_hosts) - set(qloud_hosts):
            print "Purging, " + host + ": ",
            ans = requests.delete(CONDUCTOR_API + 'hosts/' + host, headers={
                "Authorization": "OAuth " + CONDUCTOR_TOKEN}).status_code
            print "%s: %s" % (host, ans)

    print ""

    if len(set(qloud_hosts) - set(conductor_hosts)) > 0:
        print " == ADDING %s TO %s ==" % (qloud_path, group)
        for host in set(qloud_hosts) - set(conductor_hosts):
            short = re.sub('\..*', '', host)
            dc = re.sub('-.*', '', host)
            dc = re.sub('sas.*', 'sas', dc)
            dc = re.sub('vla.*', 'vla', dc)
            host_data = {'host[fqdn]': host, 'host[datacenter_name]': dc,
                         'host[short_name]': short, 'host[group_name]': group}
            host_data = urlencode(host_data)
            ans = requests.post(CONDUCTOR_API + 'hosts', headers={
                                "Authorization": "OAuth " + CONDUCTOR_TOKEN}, data=host_data).status_code
            #ans = json.loads(ans)['fqdn'][0]
            print "%s: %s" % (host, ans)
