#!/usr/bin/python
# -*- coding: UTF-8 -*-

import os.path
import os
import time
import json

STATUS_FILE = '/var/log/qnductor.status'
WAIT_TS_FILE = '/tmp/delay_monitor_ts'
DELAY = 60*60 # doubled in worst case

def now():
    return int(time.time())

def can_wait_for_start():
    try:
        ts = None
        if os.path.isfile(WAIT_TS_FILE):
            with open(WAIT_TS_FILE) as f:
                ts = int(f.read())
        else:
            ts = now()
            with open(WAIT_TS_FILE, 'w') as f:
                f.write(str(ts))
        return now() - ts < DELAY
    except Exception as x:
        print "2; can_wait_for_start exception: {}, {}".format(x.__class__.__name__, str(x))
        exit(0)


if not os.path.isfile(STATUS_FILE):
    # qnductor hasn't been started yet
    if can_wait_for_start():
        print "0; Waiting for status file"
    else:
        print "2; No status file for more than {} seconds".format(DELAY)
    exit(0)

try:
    with open(STATUS_FILE) as f:
        status = json.load(f)
        name = "environment_update_ts"

        if name not in status:
            if can_wait_for_start():
                print "0; Waiting for {} in status file".format(name)
            else:
                print "2; No {} in status file for more than {} seconds".format(name, DELAY)
            exit(0)

        update_delay = now() - int(status[name])
        if update_delay > DELAY:
            print "2; No succesfull update for more than {} seconds".format(DELAY)
        else:
            print "0; OK"
except Exception as x:
    descr = "Exception: {}, {}".format(x.__class__.__name__, str(x))
    if can_wait_for_start():
        print "0; " + descr
    else:
        print "2; " + descr
