#include <util/generic/string.h>
#include <util/stream/output.h>
#include <util/system/cpu_id.h>
#include <util/system/defaults.h>

typedef bool (*TFuncPtr)();

struct TTestFunction {
    TString Name;
    TFuncPtr Func;
};

static bool IsAMD() {
    ui32 store[4];
    NX86::CpuId(0, store);
    std::swap(store[2], store[3]);
    TStringBuf manufacturer((const char*)store + 4, 12);

    return manufacturer == "AuthenticAMD";
}

#define NX86_TEST_FUNCTION(Func) {Y_STRINGIZE(Func), NX86::Func}

static const TTestFunction TestFunctions[] = {
    NX86_TEST_FUNCTION(HaveAVX),
    NX86_TEST_FUNCTION(HaveAVX2),
    {"IsAMD", IsAMD}
};

int main(int argc, char* argv[]) {
    if (argc == 2) {
        for (const TTestFunction* iter = TestFunctions; iter != Y_ARRAY_END(TestFunctions); ++iter) {
            if (iter->Name == argv[1]) {
                if (iter->Func()) {
                    return 0;
                } else {
                    return 1;
                }
            }
        }
    }

    TString allFunctions;
    for (size_t i = 0; i < Y_ARRAY_SIZE(TestFunctions); ++i) {
        allFunctions += TestFunctions[i].Name;
        allFunctions += '|';
    }
    allFunctions.back() = '}';
    Cerr << "Usage: " << argv[0] << " {" << allFunctions << Endl;
    return 2;
}

