import click

from mail.tools.dbaas.helpers.types.env import Envs, Env
from mail.tools.dbaas.helpers.yc_client import YcClient
from mail.tools.dbaas.helpers.shards import add_shard_to_sharddb, SHARD_NAME_RE


@click.command('add-shard-to-sharddb')
@click.option('--cluster-name')
@click.option('--env', 'env_name', default=Envs.prod.value.name)
@click.option('--load-type', default='dbaas_hot')
def main(cluster_name: str, env_name: str, load_type: str):
    env: Env = Envs[env_name].value
    yc = YcClient(cloud_id=env.cloud_id, folder_name=env.folder_name)
    try:
        cluster = next(cluster for cluster in yc.get_clusters() if cluster['name'] == cluster_name)
    except StopIteration:
        raise RuntimeError(f'No cluster found with name {cluster_name}')
    hosts = yc.get_hosts(cluster_name)
    shard_name = SHARD_NAME_RE.match(cluster['name']).group('shard_name')
    shard_id = add_shard_to_sharddb(env, shard_name, hosts, load_type)
    print(f'Shard id: {shard_id}')


if __name__ == '__main__':
    main()
