import click

from mail.tools.dbaas.helpers.types.env import Envs, Env
from mail.tools.dbaas.helpers.yav import get_users_from_yav
from mail.tools.dbaas.helpers.shards import get_shard_id, get_users, get_shard_users, report_users, UserPresence, get_shard_master_dsn


@click.command('check-shards-users')
@click.option('--shard-name', required=True)
@click.option('--env', 'env_name', default=Envs.prod.value.name)
@click.option('--db_user', default='transfer')
def main(shard_name: str, env_name: str, db_user: str):
    env: Env = Envs[env_name].value
    users = get_users_from_yav(env.users_file)

    shard_id = get_shard_id(env.sharpei_dsn, shard_name)
    print(f'Shard id: {shard_id}')

    alive_users, deleted_users = get_users(env.sharpei_dsn, shard_id)

    shard_dsn = get_shard_master_dsn(env.sharpei_dsn, shard_id, db_user, users[db_user]['password'])
    shard_users = get_shard_users(shard_dsn)
    report_users(
        shard_name,
        alive_users - shard_users[UserPresence(is_here=True, is_deleted=False)],
        'extra_alive_in_sharddb',
    )

    report_users(
        shard_name,
        deleted_users - shard_users[UserPresence(is_here=True, is_deleted=True)],
        'extra_deleted_in_sharddb',
    )
    report_users(
        shard_name,
        shard_users[UserPresence(is_here=True, is_deleted=False)] - alive_users,
        'extra_alive_in_maildb'
    )
    report_users(
        shard_name,
        shard_users[UserPresence(is_here=True, is_deleted=True)] - deleted_users,
        'extra_deleted_in_maildb'
    )


if __name__ == '__main__':
    main()
