import click
import psycopg2

from mail.tools.dbaas.helpers.types.env import Envs, Env


@click.command('open-shard-for-load')
@click.option('--shard-name', required=True)
@click.option('--env', 'env_name', default=Envs.prod.value.name)
@click.option('--reg_weight', default=10)
@click.option('--can-transfer-to/--no-can-transfer-to', default=None)
def main(shard_name: str, env_name: str, reg_weight: int, can_transfer_to: bool):
    env: Env = Envs[env_name].value
    with psycopg2.connect(env.sharpei_dsn) as conn:
        cur = conn.cursor()
        cur.execute(
            'select shard_id from shards.shards where name = %(shard_name)s',
            vars=dict(
                shard_name=shard_name,
            )
        )
        shard_id = cur.fetchone()[0]
        print(f'Shard id: {shard_id}')
        cur.execute(
            '''
            update shards.shards
            set reg_weight = %(reg_weight)s
            where shard_id = %(shard_id)s
            ''',
            vars=dict(
                reg_weight=reg_weight,
                shard_id=shard_id,
            )
        )
        if can_transfer_to is not None:
            # Deprecated, moved to shiva.shards @ huskydb
            cur.execute(
                '''
                insert into shards.shards_load(shard_id, can_transfer_to)
                values (%(shard_id)s, %(can_transfer_to)s)
                on conflict (shard_id) do update
                set can_transfer_to = excluded.can_transfer_to
                ''',
                vars=dict(
                    shard_id=shard_id,
                    can_transfer_to=can_transfer_to,
                )
            )
            with psycopg2.connect(env.huskydb_dsn) as husky_conn:
                husky_cur = husky_conn.cursor()
                husky_cur.execute(
                    '''
                    UPDATE shiva.shards
                       SET can_transfer_to = %(can_transfer_to)s
                     WHERE shard_id = %(shard_id)s
                    ''',
                    vars=dict(
                        shard_id=shard_id,
                        can_transfer_to=can_transfer_to,
                    )
                )


if __name__ == '__main__':
    main()
