import click

from mail.tools.dbaas.helpers.types.env import Envs, Env
from mail.tools.dbaas.helpers.shards import set_shard_workload_exception


@click.command('set-shard-workload')
@click.option('--env', 'env_name', default=Envs.prod.value.name)
@click.option('--shard-id', required=True, type=int)
@click.option('--max-workers', required=True, type=int)
def main(env_name: str, shard_id: int, max_workers: int):
    env: Env = Envs[env_name].value
    set_shard_workload_exception(env, shard_id, max_workers)
    print(f'Set "max_workers" value for shard id {shard_id} to {max_workers}')


if __name__ == '__main__':
    main()
