import click

import yaml
from mail.tools.dbaas.helpers.types.env import Envs, Env
from mail.tools.dbaas.helpers.yc_client import YcClient


@click.command('clusters_list')
@click.option('--env', 'env_name', default=Envs.prod.value.name)
def main(env_name: str):
    env: Env = Envs[env_name].value
    yc = YcClient(cloud_id=env.cloud_id, folder_name=env.folder_name)
    print(yaml.dump([
        {k: cluster[k] for k in (
            'id',
            'name',
            'description',
            'status',
            'created_at',
            # 'name_info',
        )}
        for cluster in yc.get_clusters()
    ], indent=4, sort_keys=False))


if __name__ == '__main__':
    main()
