import webbrowser
import click
import logging
from pathlib import Path
from mail.tools.dbaas.helpers.types.env import Infra
from mail.tools.infra.infra import get_token, add_event, finish_event as finish_event_impl, get_event_url

log = logging.getLogger(__name__)


__INFRA_TOKEN__ = None


def get_or_init_token():
    global __INFRA_TOKEN__
    if not __INFRA_TOKEN__:
        __INFRA_TOKEN__ = get_token()
    return __INFRA_TOKEN__


__EVENT_ID_PATH__ = Path.home() / ".migrate_infra_event"


def finish_event(event_id):
    response = finish_event_impl(get_or_init_token(), event_id)
    assert 'id' in response, 'Failed to finish the event: {}'.format(get_event_url(event_id))
    __EVENT_ID_PATH__.unlink()


def continue_with_existing_event():
    if not __EVENT_ID_PATH__.is_file():
        return False
    event_id = __EVENT_ID_PATH__.read_text()
    event_id = int(event_id)
    text = 'There is an existing event:\n{}\nDo you want to continue with it?'.format(get_event_url(event_id))
    if click.confirm(text, default=True):
        return event_id
    if click.confirm('Would you like to finish it?\nPerhaps it is already finished', default=True):
        finish_event(event_id)
    return False


def create_event(infra: Infra, severity: str):
    existing_event = continue_with_existing_event()
    if existing_event:
        return existing_event

    response = add_event(
        token=get_or_init_token(), title=infra.title, description=infra.description, environment_id=infra.environment_id,
        service_id=infra.service_id, event_type='maintenance', severity=severity
    )

    assert 'id' in response, 'Failed to create an event'

    event_id = response['id']
    event_url = get_event_url(event_id)
    __EVENT_ID_PATH__.write_text(str(event_id))
    log.info('Created event in infra: {}'.format(event_url))

    try:
        webbrowser.open_new_tab(event_url)
    except:
        pass
    return event_id
