from dataclasses import dataclass
from enum import unique, Enum


__INFRA_DESC__ = 'You can track the progress using this chart\n{}'


@dataclass
class Infra:
    service_id: int
    environment_id: int
    description: str
    title: str = 'Rolling out migrations'


@dataclass
class Env:
    name: str
    mdb_env_name: str
    cloud_id: str
    folder_name: str
    users_file: str
    shiva_loc: str
    sharpei_dsn: str = None  # TODO : use ora2pg.tools.find_sharddb
    huskydb_dsn: str = None
    callmeback_dsn: str = None
    infra: Infra = None


@unique
class Envs(Enum):
    load = Env(
        'load', 'prestable', 'foo1ctds0jd9p70i3rb8', 'mail', 'users_load.yaml',
        'http://shiva-load.mail.yandex.net',
        'host=c-mdb89eo15641i2ooopcf.rw.db.yandex.net port=6432 dbname=sharddb user=sharpei',
        'host=c-mdb7mrj7hkstveauf28g.rw.db.yandex.net port=6432 dbname=huskydb user=sharpei',
        'host=c-482d6b0a-a096-4692-b5c8-4af1680064d2.rw.db.yandex.net port=6432 dbname=callmebackdb_test user=callmeback',
        Infra(3959, 5968, __INFRA_DESC__.format('https://yasm.yandex-team.ru/template/panel/Maildb-dbstats/prj=mail.samsara.load/21/')),
    )
    test = Env(
        'test', 'prestable', 'foohmmij9e9dtob4voua', 'testmailmetabase', 'users_test.yaml',
        'http://shiva-test.mail.yandex.net',
        'host=c-mdbfi97nl13865k7lfs7.rw.db.yandex.net port=6432 dbname=sharddb user=sharpei',
        'host=c-f377c83d-618d-4c42-b3b3-6713df472be9.rw.db.yandex.net port=6432 dbname=huskydb_test user=sharpei',
        'host=c-482d6b0a-a096-4692-b5c8-4af1680064d2.rw.db.yandex.net port=6432 dbname=callmebackdb_test user=callmeback',
        Infra(3959, 5968, __INFRA_DESC__.format('https://yasm.yandex-team.ru/template/panel/Maildb-dbstats/prj=mail.samsara.test/21/')),
    )
    prod = Env(
        'prod', 'production', 'foopv9i9psjvamch5um0', 'mailmetabase', 'users.yaml',
        'http://shiva-prod.mail.yandex.net',
        'host=c-mdbd8ebfpfh8ult1t721.rw.db.yandex.net port=6432 dbname=sharddb user=sharpei',
        'host=c-58afb252-b83e-43b3-9949-d12c4b0c9d4d.rw.db.yandex.net port=6432 dbname=huskydb user=sharpei',
        'host=c-6a12b272-08ce-417d-a208-5ceac6293ba6.rw.db.yandex.net port=6432 dbname=callmebackdb_prod user=callmeback',
        Infra(352, 561, __INFRA_DESC__.format('https://yasm.yandex-team.ru/template/panel/Maildb-dbstats/prj=mail.samsara.production/21/')),
    )
    corp = Env(
        'corp', 'production', 'footrdt7eqpucethl7of', 'corpmailmetabase', 'users_corp.yaml',
        'http://shiva-corp.mail.yandex.net',
        'host=c-mdbm78cpbp77blunrfpo.rw.db.yandex.net port=6432 dbname=sharddb user=sharpei',
        'host=c-f31d3eb0-040b-4fc8-9dc1-338eb9db8e51.rw.db.yandex.net port=6432 dbname=huskydb_intranet user=sharpei',
        'host=c-6a12b272-08ce-417d-a208-5ceac6293ba6.rw.db.yandex.net port=6432 dbname=callmebackdb_prod user=callmeback',
        Infra(352, 5844, __INFRA_DESC__.format('https://yasm.yandex-team.ru/template/panel/Maildb-dbstats/prj=mail.samsara.intranet-production/21/')),
    )
