from dataclasses import dataclass, field


@dataclass(order=True)
class Migration:
    version: int
    description: str
    transactional: bool
    installed_on: str
    installed_by: str = field(repr=False)
    type: str = field(repr=False)

    @property
    def applied(self):
        return self.installed_on is not None
