import yaml

from library.python.vault_client.instances import Production as VaultClient
from library.python.vault_client.errors import ClientError


def get_users_from_yav(users_file):
    secret_id = 'sec-01d5v5dv67pza174zneyt5s1tf'

    client = VaultClient(decode_files=True)

    try:
        secret = client.get_version(secret_id)
    except ClientError:
        raise

    if users_file in secret['value']:
        secret_yaml = yaml.safe_load(secret['value'][users_file])
    else:
        raise Exception('File {} not found in secret'.format(users_file))

    return secret_yaml
