#! /usr/bin/env python

import json
import os
import sys

import requests


def get_uids(oauth_token):
    url = (
        "http://staff-api.yandex-team.ru/v3/persons"
        "?_limit=1000&official.is_dismissed=false&official.affiliation=yandex&_fields=uid,official,login,department_group"
    )
    headers = {"Authorization": "OAuth " + oauth_token}
    while True:
        print url
        resp = requests.get(url, headers=headers, timeout=30)
        if resp.status_code != 200:
            raise Exception("staff response error: {} {}".format(resp.status_code, resp.text))
        resp_dict = json.loads(resp.text)
        for person in resp_dict["result"]:
            yield person["uid"]
        links = resp_dict["links"]
        if "next" in links:
            url = links["next"]
        else:
            break


def main():
    if len(sys.argv) < 2:
        print "usage: {} <output file>".format(sys.argv[0])
        return 1
    output_file = sys.argv[1]
    with open(output_file, "w") as f:
        for uid in get_uids(os.environ["STAFF_OAUTH_TOKEN"]):
            f.write(uid + "\n")


main()
