#! /usr/bin/env python

import sys
import os
import requests
import json
import datetime

STAFF_OFFICES = {"moscow": "Moscow", "piter": "St.+Petersburg"}


def get_uids(oauth_token, office):
    url = "http://staff-api.yandex-team.ru/v3/persons"
    url += "?_limit=1000&location.office.city.name.en={}&_fields=uid,official,login".format(STAFF_OFFICES[office])
    headers = {"Authorization": "OAuth " + oauth_token}
    while True:
        print url
        resp = requests.get(url, headers=headers, timeout=5)
        if resp.status_code != 200:
            raise Exception("staff response error: {} {}".format(resp.status_code, resp.text))
        resp_dict = json.loads(resp.text)
        for person in resp_dict["result"]:
            quit_date_str = person["official"].get("quit_at")
            if not quit_date_str:
                yield person["uid"]
                continue
            quit_date = datetime.datetime.strptime(quit_date_str, '%Y-%m-%d')
            if quit_date >= datetime.datetime(2018, 6, 1):
                yield person["uid"]
        links = resp_dict["links"]
        if "next" in links:
            url = links["next"]
        else:
            break


def main():
    if len(sys.argv) < 3:
        print "usage: {} <office> <output file>".format(sys.argv[0])
        return 1
    office = sys.argv[1]
    if office not in STAFF_OFFICES:
        print "office must be one of the following: {}".format(STAFF_OFFICES.keys())
        return 1
    output_file = sys.argv[2]
    with open(output_file, "w") as f:
        for uid in get_uids(os.environ["STAFF_OAUTH_TOKEN"], office):
            f.write(uid + "\n")


main()
