#! /usr/bin/env python
# -*- coding: utf-8 -*-

import csv
import os
import json
import sys


def read_events(events_dir):
    res = {}
    for uid in os.listdir(events_dir):
        with open(os.path.join(events_dir, uid)) as f:
            res[uid] = json.load(f)
    return res


def merge_events(events):
    res = {}
    for uid, meetings in events.iteritems():
        for meeting in meetings:
            res[meeting["event_id"]] = meeting
    return res


def dump_result(events, output_path):
    print "dumping csv to {} .....".format(output_path)
    with open(output_path, 'w') as outfile:
        writer = csv.writer(outfile, delimiter=';')
        writer.writerow([
            'event-id',
            'date',
            'time',
            'organizer',
            'room-name',
            'room-type',
            'room-description',
        ])
        for event_id, event in events.iteritems():
            for room in event["rooms"]:
                room_description = room["description"] if room["resourceType"] != "room" else u"---Нет описания----"
                writer.writerow([
                    event_id,
                    event["date"],
                    event["time"][:-3],
                    event["organizer"],
                    room["name"].encode('utf-8'),
                    room["resourceType"],
                    room_description.encode('utf-8')
                ])


def main():
    if len(sys.argv) < 3:
        print "usage: {} <events dir> <output file>".format(sys.argv[0])
        return 1
    events_dir = sys.argv[1]
    output_file = sys.argv[2]
    print "reading events from", events_dir
    user2events = read_events(events_dir)
    print "merging events from {} users".format(len(user2events))
    uniq_events = merge_events(user2events)
    print "dumping {} events".format(len(uniq_events))
    dump_result(uniq_events, output_file)
    print "done"

main()
