#! /usr/bin/env python
# -*- coding: utf-8 -*-

import csv
import sys

def read_events(path):
    events = {}
    with open(path, 'r') as csvfile:
        reader = csv.DictReader(csvfile, delimiter=';')
        for row in reader:
            event_id = row["event-id"]
            room_name = row["room-name"]
            if event_id not in events:
                events[event_id] = {}
            events[event_id][room_name] = {
                "date": row["date"],
                "time": row["time"],
                "organizer": row["organizer"],
                "room-type": row["room-type"],
                "room-description": row["room-description"],
            }
    return events

def read_declines(path):
    declines = {}
    with open(path, 'r') as csvfile:
        reader = csv.DictReader(csvfile, delimiter=';')
        for row in reader:
            event_id = row["event-id"]
            if event_id not in declines:
                declines[event_id] = set()
            declines[event_id].add(row["room-name"])
    return declines

def merge(events, declines):
    res = dict(events)
    for event_id, event_data in events.iteritems():
        for room_name, reservation in event_data.iteritems():
            was_cancelled = event_id in declines and room_name in declines[event_id]
            res[event_id][room_name]["was-cancelled"] = was_cancelled
    return res

def dump_result(events, path):
    fieldnames = [
        'event-id',
        'date',
        'time',
        'organizer',
        'room-name',
        'room-type',
        'room-description',
        'was-cancelled'
    ]
    with open(path, 'w') as outfile:
        writer = csv.DictWriter(outfile, fieldnames, delimiter=';')
        writer.writeheader()
        for event_id, event_data in events.iteritems():
            for room_name, reservation in event_data.iteritems():
                writer.writerow({
                    'event-id': event_id,
                    'date': reservation['date'],
                    'time': reservation['time'],
                    'organizer': reservation['organizer'],
                    'room-name': room_name,
                    'room-type': reservation['room-type'],
                    'room-description': reservation['room-description'],
                    'was-cancelled': reservation['was-cancelled'],
                })


def main():
    if len(sys.argv) < 4:
        print "usage: {} <events.csv> <cancel-reservations.csv> <output.csv>".format(sys.argv[0])
        return 1
    events_path = sys.argv[1]
    declines_path = sys.argv[2]
    output_path = sys.argv[3]

    print events_path
    print declines_path
    print output_path

    events = read_events(events_path)
    print "read {} events".format(len(events))
    declines = read_declines(declines_path)
    print "read {} declines".format(len(declines))
    merged = merge(events, declines)
    print "merged events with declines"
    dump_result(merged, output_path)
    print "done"

main()
