#!/usr/bin/env python3

import json
import requests

JUGGLER_EVENTS_API = "http://juggler-api.search.yandex.net/api/events/complete_events"

CHECKS = [
    {"host": "mail_mxback", "service": "postfix_longrun_db_init"},
    {"host": "mail_mxback", "service": "postfix_longrun_sharpei"},
    {"host": "mail_mxfront", "service": "postfix_longrun_db_init"},
    {"host": "mail_mxfront", "service": "postfix_longrun_sharpei"},
]

IGNORE_DESCRIPTIONS = [
        "Longrun queue overflow",
        "empty"
]

def get_check_aggr_data(host, service):
    check_aggr_data = []
    check_data = requests.get(JUGGLER_EVENTS_API +
                              "?host_name=" + host +
                              "&service_name=" + service +
                              "&do=1", verify=False).json()
    for host, host_data in check_data[host][service]["description"][0]["children"].items():
        check_raw_desc = host_data[service][""]["description"]
        if check_raw_desc not in IGNORE_DESCRIPTIONS:
            check_data_list = check_raw_desc.split(", ")
            check_aggr_data += check_data_list
    return sorted(list(set(email.lower() for email in check_aggr_data)))

for check in CHECKS:
    print(f'{check["host"]}: {check["service"]}')
    print("\n".join(f'- {email}' for email in get_check_aggr_data(check["host"], check["service"])))
    print()
