import argparse
import smtplib
from mail.tools.common.postfix import get_queue, get_mail, hold, unhold, drop


DEFAULT_SMTP_HOST = 'mxbackcorp1o.mail.yandex.net'
DEFAULT_SMTP_PORT = 5252


def send_mail(queue_elem, mail, host, port):
    mail_from = queue_elem['sender']
    if mail_from == 'MAILER-DAEMON':
        mail_from = ''
    rcpts = map(lambda r: r['address'], queue_elem['recipients'])
    if not rcpts:
        raise RuntimeError('Something went wrong: empty recipients')

    smtp = smtplib.SMTP(host, port, timeout=5.0)
    smtp.set_debuglevel(True)
    res = smtp.sendmail(mail_from, rcpts, mail)
    smtp.quit()
    if res:
        raise RuntimeError('Failed to send mail to the following recipients: {}'.format(res))


def main(queue_id, smtp_host, smtp_port):
    queue = get_queue()
    queue_elem = filter(lambda e: e['queue_id'] == queue_id, queue)
    if not queue_elem:
        print('Queue elem with id {} not found'.format(queue_id))
        exit(1)
    queue_elem = queue_elem[0]
    hold(queue_id)
    mail = get_mail(queue_id)
    if not mail:
        print('Could not get mail body with queue id {}'.format(queue_id))
        unhold(queue_id)
        exit(1)
    try:
        send_mail(queue_elem, mail, smtp_host, smtp_port)
        drop(queue_id, 'hold')
    except RuntimeError as e:
        print('Failed to send mail: ' + e.message)
        exit(1)


def parse_args():
    parser = argparse.ArgumentParser(description='Re-send email from postfix queue using specified host:port')
    parser.add_argument('-q', '--queue-id', dest='queue_id', type=str, required=True,
                        help='Postfix queue id')
    parser.add_argument('-H', '--host', dest='smtp_host', type=str, default=DEFAULT_SMTP_HOST,
                        help='SMTP host for sending email')
    parser.add_argument('-p', '--port', dest='smtp_port', type=int, default=DEFAULT_SMTP_PORT,
                        help='SMTP port')
    return parser.parse_args()


if __name__ == '__main__':
    main(**dict(parse_args()._get_kwargs()))
