#! /usr/bin/env python

import subprocess
import argparse


ENVIRONMENTS = {
    "corp": {
        "host": "amber-2013.yandex-team.ru",
        "domain": "ld",
        "login": "invitebot2013",
    },
    "testing": {
        "host": "test-mail4.yandex.net",
        "domain": "msft",
        "login": "testuser2013",
    },
}


def call(args):
    host = ENVIRONMENTS[args.env]["host"]
    domain = ENVIRONMENTS[args.env]["domain"]
    login = ENVIRONMENTS[args.env]["login"]
    password = args.password

    with open(args.body) as f:
        data = f.read()

    command = [
        "curl",
        "--ntlm",
        "-H", "Content-Type: text/xml; charset=UTF-8",
        "-u" '{}\{}:{}'.format(domain, login, password),
        "-d", data,
    ]
    if args.verbose:
        command.append("-v")
    command.append("https://{}/ews/exchange.asmx".format(host))
    if args.verbose:
        print " ".join(command)
    subprocess.call(command)


def main():
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument("-e", "--env", choices=ENVIRONMENTS.keys(), default="corp",
                        help="Environment of Exchange to request")
    parser.add_argument("-v", "--verbose", action="store_true",
                        help="Show debug info")
    parser.add_argument("-p", "--password", required=True,
                        help="Exchange user's password, whose account we use for EWS call")
    parser.add_argument("body",
                        help="File with request body in XML format")
    args = parser.parse_args()
    call(args)

if __name__ == "__main__":
    main()
