#!/bin/sh

# sleep for async
sleep $((RANDOM%60))

security_url="http://admin-api.sq2.yandex.ru/monitoring/"
virtual_alias_maps="/etc/yandex/sorm-aliases/virtual_alias_maps"
mkdir -p $(dirname ${virtual_alias_maps})

hostname=`hostname -f`

# add alias for root
echo "root@${hostname}	mail-root@yandex-team.ru" > $virtual_alias_maps.tmp

# add alias for sms-alerting package
echo "@mobile.yandex-team.ru	mobile@mobile.yandex-team.ru" >> $virtual_alias_maps.tmp

# add alias for test purpose
echo "sid-66-test@yandex.ru	test-66-get@yandex.ru
test-virtual-alias@yandex.ru	test-virtual-alias%yandex.ru@mxbacks.yandex.ru,test-virtual-alias-get@yandex.ru" >> $virtual_alias_maps.tmp

# add other stuff
echo "annick@yandex.ru	annick@comptek.ru
davydov@yandex.ru	davydov@comptek.ru
den@yandex.ru	den@yandex-team.ru
dz@yandex.ru	dz@yandex-team.ru
egor@yandex.ru	egor@comptek.ru
eml@yandex.ru	eml@yandex-team.ru
gol@yandex.ru	gol@comptek.ru
ivanov@yandex.ru	ivanov@comptek.ru
jane@yandex.ru	janetg@so.yandex.ru
jil@yandex.ru	jil@comptek.ru
julya@yandex.ru	julya@comptek.ru
klm@yandex.ru	klm@yandex-team.ru
kostik@yandex.ru	kostik@comptek.ru
ksanych@yandex.ru	ksanych@yandex-team.ru
kuzmin@yandex.ru	kuzmin@yandex-team.ru
kuzya@yandex.ru	kuzya@comptek.ru
lubaoz@yandex.ru	lubaoz@comptek.ru
leo@yandex.ru	leo@yandex-team.ru
leon@yandex.ru	leon@comptek.ru
lsurn@yandex.ru	lsurn@yandex-team.ru
maria@yandex.ru	iseg@yandex-team.ru
mart@yandex.ru	mart@comptek.ru
masham@yandex.ru	masham@yandex-team.ru
mershova@yandex.ru	mershova@comptek.ru
migel@yandex.ru	migelf@yandex.ru
neverov@yandex.ru	neverov@yandex-team.ru
pete@yandex.ru	pete@comptek.ru
rekub@yandex.ru	rekub@yandex-team.ru
savo@yandex.ru	savo@comptek.ru
sergey@yandex.ru	sergey@yandex-team.ru
slava@yandex.ru	slava@yandex-team.ru
smargolin@yandex.ru	smargolin@yandex-team.ru
stas@yandex.ru	stas@comptek.ru
svetta@yandex.ru	svetta@yandex-team.ru
tejblum@yandex.ru	tejblum@yandex-team.ru
uht@yandex.ru	uht@yandex-team.ru
vladik@yandex.ru	vladik@yandex-team.ru
vlads@yandex.ru	vlads@yandex-team.ru
volozh@yandex.ru	volozh@yandex-team.ru
banner@yandex.ru	banner@yandex-team.ru
cy@yandex.ru	cy@yandex-team.ru
hudsovet@yandex.ru	hudsovet@yandex-team.ru
kodak@yandex.ru	kodak@yandex-team.ru
map@yandex.ru	map@yandex-team.ru
narod@yandex.ru	narod@yandex-team.ru
sales@yandex.ru	sales@yandex-team.ru
pr@yandex.ru	pr@yandex-team.ru
pr@yandex.com.tr	pr-turkey@yandex-team.ru
info@yandex.ru	info@yandex-team.ru
info@yandex.ua	info@yandex-team.com.ua
info@ya.ru	info@yandex-team.ru
info@narod.ru	info@yandex-team.ru
shop@yandex.ru	shop@yandex-team.ru
soft@yandex.ru	soft@yandex-team.ru
subscr@yandex.ru	subscr@yandex-team.ru
syntax@yandex.ru	syntax@yandex-team.ru
wap@yandex.ru	wap@yandex-team.ru" >> $virtual_alias_maps.tmp

# add security aliases
curl --connect-timeout 5 -s $security_url | grep -v ^$ | awk -F \; '{aliases[$1] = aliases[$1] "," $2} END {for (email in aliases) {aliases[email] = email aliases[email]; print email "\t" aliases[email]}}' | sort >> $virtual_alias_maps.tmp

if [ -s $virtual_alias_maps.tmp ] ; then
    mv $virtual_alias_maps.tmp $virtual_alias_maps
    if [ -x "$(command -v postmap)" ] && [ -x "$(command -v postfix)" ]; then
        postmap $virtual_alias_maps
        postfix reload > /dev/null 2>&1
    fi
    killall -SIGHUP nwsmtp > /dev/null 2>&1
else
    echo "Can't make $virtual_alias_maps.tmp"
    rm -f $virtual_alias_maps.tmp
    exit 1
fi
