# coding=utf-8
import logging
import os
import shutil
from urllib.parse import urlencode

import requests
from urllib3.exceptions import InsecureRequestWarning

requests.packages.urllib3.disable_warnings(category=InsecureRequestWarning)

CHARTS_HOST = 'https://charts.yandex-team.ru'

logger = logging.getLogger('app')

__token = 'None'

__endpoint = 'https://charts.yandex-team.ru/api/scr/v1/screenshots'

__report_dir = 'report'


def __get_headers():
    return {
        'authorization': 'OAuth ' + __token,
        'content-type': 'application/x-www-form-urlencoded'
    }


def set_token(token):
    global __token
    __token = token


def __construct_params(url):
    if '?' in url:
        url += '&'
    else:
        url += '?'
    url += '_embedded=1&_no_controls=1'
    if '/preview/editor/alena/zbp/' in url:
        return {
            'path': url,
            'width': 1920,
            'height': 650,
        }
    else:
        return {
            'path': url,
            'width': 720,
            'height': 400
        }

def get_metric_img(url):
    if str(url).startswith('https://charts.yandex-team.ru'):
        try:
            return make_screenshot(url)
        except Exception:
            logger.error("Skipped metric for url: %s", url)
            pass
    return None


def getRedirectLocation(url, headers):
    logger.warning('Getting redirects on %s', url)
    response = requests.head(url, headers=headers, verify=False)
    if response.status_code == 302:
        location = response.headers['location']
        if '://' in location:
            redirection_url = location
        else:
            redirection_url = CHARTS_HOST + location
        return getRedirectLocation(redirection_url, headers)
    return url


def make_inner_screenshot(path):
    payload = urlencode(__construct_params(path))
    response = requests.post(__endpoint, data=payload, headers=__get_headers(), stream=True, verify=False)
    return response


def make_screenshot(url):
    if not url.startswith(CHARTS_HOST):
        raise Exception('Provided url: ' + url + ' is not a Yandex.Charts url!')

    path = url.replace(CHARTS_HOST, '')

    response = make_inner_screenshot(path)
    if response.status_code / 100 == 4 or response.status_code == 504:
        logger.warning('Failed to make screenshot on %s, response code %s', path, response.status_code)
        location = getRedirectLocation(url, __get_headers())
        path = location.replace(CHARTS_HOST, '')
        response = make_inner_screenshot(path)
        if response.status_code / 100 == 4 or response.status_code == 504:
            logger.warning('Failed to make screenshot on %s, response code %s', path, response.status_code)
            return None

    if not os.path.exists(__report_dir):
        os.makedirs(__report_dir)

    file_name = path.replace('/', '').split('?')[0]

    if os.path.isfile(__report_dir + '/' + file_name):
        iterator = 1
        while os.path.isfile(__report_dir + '/' + file_name + str(iterator)):
            iterator += 1
        file_name += str(iterator)

    with open(__report_dir + '/' + file_name, 'wb') as out_file:
        shutil.copyfileobj(response.raw, out_file)

    return file_name
