import json
import smtplib
from email.mime.image import MIMEImage
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
import logging

logger = logging.getLogger('app')

__login = ''
__password = ''


def set_credentials(login, password):
    global __password
    __password = password
    global __login
    __login = login


def compose(body, report_items):
    msg_root = MIMEMultipart('related')
    msg_root.set_charset('utf-8')
    msg_root.preamble = 'Goals report'

    msg_root.attach(MIMEText(body, 'html', 'utf-8'))

    for report_item in report_items:
        for metric in report_item.metrics:
            if metric.cached_img_file:
                try:
                    fp = open('report/' + metric.cached_img_file, 'rb')
                    metric_image = MIMEImage(fp.read())
                    fp.close()
                    metric_image.add_header('Content-ID', '<' + metric.cached_img_file + '>')
                    msg_root.attach(metric_image)
                except IOError:
                    print("error")
    return msg_root


def send(root, str_from, receivers, subject):
    root['Subject'] = subject
    root['From'] = str_from
    root['To'] = ", ".join(receivers)
    smtp = smtplib.SMTP_SSL(host='smtp.yandex-team.ru', timeout=10)
    try:
        smtp.connect('smtp.yandex-team.ru', 465)
        # smtp.set_debuglevel(1)
        smtp.ehlo()

        smtp.login(user=__login, password=__password)
        logger.debug('Sending email to ' + str(receivers) + ', len = ' + str(len(root.as_string())))
        sendmail = smtp.sendmail(str_from, receivers, root.as_string())

        logger.debug('Email done ' + json.dumps(sendmail))
    finally:
        smtp.quit()
