import json
import requests
from requests.adapters import HTTPAdapter
import time
import logging
import library.python.oauth as lpo


log = logging.getLogger(__name__)


def __get_headers(token):
    return {
        'Authorization': 'OAuth {}'.format(token),
        'Content-Type': 'application/json',
    }


def __get_session(token):
    s = requests.Session()
    s.headers.update(__get_headers(token))
    s.mount('https://', HTTPAdapter(max_retries=3))
    return s


def __post_request(url, token, data=None):
    s = __get_session(token)
    return s.post(url, data=data)


def __put_request(url, token, data=None):
    s = __get_session(token)
    return s.put(url, data=data)


def get_token(client_id='91d9b673cc55491682a5652d14fe641c', client_secret='8b5979e67ea2492ba53bda37f1550cae', login=None, keys=None):
    return lpo.get_token(client_id, client_secret, login=login, keys=keys)


def add_event(token, title, description, environment_id, service_id, event_type, severity,
                tickets=None, start_time=None, finish_time=None, data_centers=None, send_email=False):
    log.info('Adding event')
    data = {
        'title': title,
        'description': description,
        'environmentId': environment_id,
        'serviceId': service_id,
        'startTime': start_time,
        'type': event_type,
        'severity': severity,
        'sendEmailNotifications': send_email
    }

    if data_centers is None:
        data['setAllAvailableDc'] = True
    else:
        for dc in data_centers:
            data[dc] = True
    if start_time is None:
        data['startTime'] = int(time.time())
    if tickets:
        data['tickets'] = tickets
    if finish_time:
        data['finishTime'] = finish_time

    url = 'https://infra-api.yandex-team.ru/v1/events'
    return __post_request(url, token, json.dumps(data)).json()


def finish_event(token, event_id, finish_time=None):
    log.info('Finishing event {}'.format(event_id))
    data = {}
    if finish_time:
        data['finishTime'] = finish_time
    else:
        data['finishTime'] = int(time.time())

    url = 'https://infra-api.yandex-team.ru/v1/events/{}'.format(event_id)
    return __put_request(url, token, json.dumps(data)).json()


def get_event_url(event_id):
    return 'https://infra.yandex-team.ru/event/{}'.format(event_id)
